% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRed.R
\name{pca.Deville}
\alias{pca.Deville}
\title{Perform a PCA using Deville's method}
\usage{
pca.Deville(X, t, t.range, breaks)
}
\arguments{
\item{X}{a data matrix}

\item{t}{a matrix of observation times corresponding to X}

\item{t.range}{the range of observation times in vector form (ex. t.range = c(0, 1000))}

\item{breaks}{integer number of histogram windows}
}
\value{
X.histo the matrix projected onto the histogram basis

U.histo a matrix of eigenvectors in the histogram basis

Cp a matrix of principal components

lambda a vector of eigenvalues

perc.lambda a vector of the percentage of total inertia explained by each principal component
}
\description{
Perform a PCA using Deville's method
}
\examples{
res <- drbats.simul(N = 5, P = 100, t.range = c(5, 100), breaks = 8)
res.pca <- pca.Deville(res$X, res$t.simul, t.range = c(5, 100), breaks = 8)
res.pca

}
\references{
JC Deville, "Methodes statisiques et numeriques de l'analyse harmonique", Annales de l'INSEE, 1974.
}
\author{
Gabrielle Weinrott
}
