% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonizeEEM.R
\name{commonizeEEM}
\alias{commonizeEEM}
\title{Smooth out the different dimensions of EEM data}
\usage{
commonizeEEM(EEM)
}
\arguments{
\item{EEM}{a list containing EEM data as created by \code{readEEM} function.}
}
\value{
EEM class object with only common variables
}
\description{
Smooth out the difference dimensions of EEM data by finding the common variables of all data and subset
those data.
}
\examples{
data(gluten)
data(applejuice)
data <- c(gluten, applejuice)
summary(data) # different dimensions
data_combined <- commonizeEEM(data)
summary(data_combined) # same dimension, ready for unfold

}

