% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{vcos}
\alias{vcos}
\title{Compute Pairwise Cosines of the Angles Between Vectors}
\usage{
vcos(vectors, silent = TRUE, digits = 3)
}
\arguments{
\item{vectors}{a named list (or dataframe) containing n-dimensional vectors.}

\item{silent}{logical, set to FALSE to avoid loneliness.}

\item{digits}{integer indicating the number of decimal places.}
}
\value{
A triangular matrix with the cosines of the angles formed between the  given vectors.
}
\description{
Computes pairwise cosines of the angles between vectors.
}
\details{
Cosines are standard measure of vector similarity. If the angle between two vectors in n-dimensional space is small, then the individual elements of their vectors must be very similar to each other in value, and the calculated cosine derived from these values is near one. If the vectors point in opposite directions, then the individual elements of their vectors must be very dissimilar in value, an the calculated cosine is near minus one.
}
\examples{
vcos(otu.space(bovids[, 1:4]))
}
\seealso{
vdis()
}
