% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{vtree}
\alias{vtree}
\title{Build a Tree When Species Are Encoded by n-Dim Vectors}
\usage{
vtree(matrix, outgroup = 'any')
}
\arguments{
\item{matrix}{either a dataframe or matrix where each column represents an OTU.}

\item{outgroup}{when a rooted tree is desired, it indicates the species to be used as outgroup.}
}
\value{
A list with two objects, the first one is an inter-species distance matrix. The second one is an object of class 'phylo'.
}
\description{
Builds a tree when species are encoded by n-dim vectors.
}
\details{
The method is based on a distance matrix obtained after converting the cos between vector (similarity measurement) in a dissimilarity measurement.
}
\examples{
data(bovids)
mymatrix <- ngraMatrix(bovids[, 6:11], k = 2)[[2]][, 2:7]
vtree(mymatrix, outgroup = "Pseudoryx_nghetinhensis")
}
\seealso{
svdgram
}
