% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulateMetaAnalysisWithNegativeControls}
\alias{simulateMetaAnalysisWithNegativeControls}
\title{Simulate survival data across a federated data network, with negative control outcomes as well.}
\usage{
simulateMetaAnalysisWithNegativeControls(
  meanExposureEffect = log(2),
  meanBias = 0.5,
  biasStd = 0.2,
  meanSiteEffect = 0,
  siteEffectStd = 0.1,
  mNegativeControls = 10,
  nSites = 10,
  sitePop = 2000,
  seed = 42,
  ...
)
}
\arguments{
\item{meanExposureEffect}{Average exposure effect; has to be on the log-scale}

\item{meanBias}{Average bias for the bias distribution}

\item{biasStd}{Standard deviation for the bias distribution}

\item{meanSiteEffect}{Average of the data-source-specific effects (typically should be zero)}

\item{siteEffectStd}{Standard deviation for data-source-specific effects}

\item{mNegativeControls}{Number of negative control outcomes}

\item{nSites}{Number of data sources}

\item{sitePop}{Population size per data source}

\item{seed}{Random seed}

\item{...}{Arguments that will be passed to other functions}
}
\description{
A function to simulate patient-level survival data for a hypothetical exposure, with simulated bias
and data-source-specific random effects. Patient-level data for negative control outcomes are simulated
as well to reflect systematic error.
}
\seealso{
\link{computeHierarchicalMetaAnalysis}
}
