% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fSACF.R
\name{fSACF}
\alias{fSACF}
\title{Functional Spherical Autocorrelation Function (fSACF) Plot}
\usage{
fSACF(f_data, H = 20, alpha = 0.05)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in a grid and \eqn{N} is the sample size.}

\item{H}{A positive integer value. The maximum lag for which to compute the coefficients and confidence bounds.}

\item{alpha}{A numeric value between 0 and 1 specifying the significance level to be used for the confidence bounds.}
}
\value{
Plot of the estimated autocorrelation coefficients for lags \eqn{h} in \eqn{1:H} with the SWN
\eqn{(1-\alpha)100 \%} upper and lower confidence bounds for each lag.
}
\description{
This function offers a graphical summary of the fSACF of a functional time series (FTS) across different time lags \eqn{h = 1:H}.
It also plots \eqn{100 \times (1-\alpha)\%}  confidence bounds developed under strong white noise (SWN) assumption for all lags \eqn{h = 1:H}.
}
\details{
This function computes and plots functional spherical autocorrelation coefficients at lag \eqn{h}, for \eqn{h = 1:H}.
The fSACF at lag \eqn{h} is computed by the average of the inner product of lagged pairs of
the series \eqn{X_i} and \eqn{X_{i+h}} that have been centered and scaled:
\deqn{
\tilde\rho_h=\frac{1}{N}\sum_{i=1}^{N-h} \langle \frac{X_i - \tilde{\mu}}{\|X_i - \tilde{\mu}\|}, \frac{X_{i+h} - \tilde{\mu}}{\|X_{i+h} - \tilde{\mu}\|} \rangle,\ \ \ \ 0 \le h < N,
}
where \eqn{\tilde{\mu}} is the estimated spatial median of the series.
It also computes estimated asymptotic \eqn{(1-\alpha)100 \%} confidence lower and upper bounds, under the SWN assumption.
}
\examples{
\donttest{
data(Spanish_elec) # Daily Spanish electricity price profiles
fSACF(Spanish_elec)
}
}
\references{
[1] Yeh C.K., Rice G., Dubin J.A. (2023). Functional spherical autocorrelation: A robust estimate of
the autocorrelation of a functional time series. Electronic Journal of Statistics, 17, 650–687.
}
