% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edgelist.R
\name{create_edgelist}
\alias{create_edgelist}
\title{Create dataframe of edgelist based on social networks and fertility data (LISS: wj18a_EN_1.0p.sav)}
\usage{
create_edgelist(data = NULL, vars = NULL)
}
\arguments{
\item{data}{Tibble which is the result of \code{create_relation_labels(fix_errors(change_column_types(translate(read_data()))))}}

\item{vars}{Vector with variable names of 25 variables describing alter-alter-ties}
}
\value{
Tibble with variable \code{edgelist} which includes a dataframe with edgelist for each respondent
}
\description{
Create dataframe of edgelist based on social networks and fertility data (LISS: wj18a_EN_1.0p.sav)
}
\examples{
\dontshow{if (file.exists("wj18a_EN_1.0p.sav")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- read_data() |> translate() |> change_column_types() |>
fix_errors() |> create_relation_labels()
create_edgelist(data[1, vars_alter_ties])
\dontshow{\}) # examplesIf}
}
