% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormEnt.R
\name{NormEnt}
\alias{NormEnt}
\title{Normalized Entropy}
\usage{
NormEnt(object, model = TRUE, parm)
}
\arguments{
\item{object}{fitted \code{\link{lmgce}} or \code{\link{tsbootgce}} object.}

\item{model}{Boolean value. if \code{model = TRUE}, the model's normalized
entropy is returned. If \code{model = FALSE} the normalized entropy of each
estimate is returned. The default is \code{model = TRUE}.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}
}
\value{
the value of the normalized entropy of the model or parameters.
}
\description{
Returns the normalized entropy of the model or the normalized entropy of the
predictors.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

NormEnt(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
