% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsbootgceclassfunctions.R
\name{coef.tsbootgce}
\alias{coef.tsbootgce}
\title{Extract \code{\link{tsbootgce}} Model Coefficients}
\usage{
\method{coef}{tsbootgce}(object, which = NULL, seed = object$seed, ...)
}
\arguments{
\item{object}{Fitted \code{\link{tsbootgce}} model object.}

\item{which}{The default is \code{which = NULL} and returns the coefficients
defined in the argument \code{coef.method} from the \code{tsbootgce} object.
Can be set as "mode" or "median" and the mode and median coefficients will be
computed, respectively (see \code{\link[hdrcde]{hdr}}).}

\item{seed}{A single value, interpreted as an integer, for reproducibility
or \code{NULL} for randomness. The default is \code{seed = object$seed}.}

\item{...}{Additional arguments.}
}
\value{
Returns the coefficients from a \code{tsbootgce} object
}
\description{
Extract coefficients from a \code{\link{tsbootgce}} object
}
\examples{
\donttest{
res.tsbootgce <-
  tsbootgce(
    formula = CO2 ~ 1 + L(GDP, 1) + L(EPC, 1) + L(EU, 1),
    data = moz_ts)

coef(res.tsbootgce)
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
