% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.lmgceclassfunctions.R
\name{coefficients.cv.lmgce}
\alias{coefficients.cv.lmgce}
\title{Extract \code{\link{cv.lmgce}} Coefficients}
\usage{
\method{coefficients}{cv.lmgce}(object, ...)
}
\arguments{
\item{object}{Fitted \code{\link{cv.lmgce}} model object.}

\item{...}{Additional arguments (not used).}
}
\value{
Returns the coefficients from a \code{\link{cv.lmgce}} object. The
coefficients are obtained from the \code{\link{lmgce}} object with best
performance. These coefficients are stored in \code{object$best$coefficients}.
}
\description{
Extract coefficients from a \code{\link{cv.lmgce}} object
}
\examples{
\donttest{
res.cv.lmgce <-
  cv.lmgce(y ~ .,
           data = dataGCE)

coefficients(res.cv.lmgce)
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
