% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address_to_coords.R
\encoding{UTF-8}
\name{address_to_coords}
\alias{address_to_coords}
\title{Convert addresses to coordinates}
\usage{
address_to_coords(zip_code, address, format = "sf", crs_out = 25833)
}
\arguments{
\item{zip_code}{Character vector with zip codes.}

\item{address}{Character vector with addresses (street name and house number).}

\item{format}{Format of the returned object. Default value is set to “sf” (which returns an \code{sf} object). It is also possible set the format to “tibble” or “data.frame”.}

\item{crs_out}{Numeric vector with the chosen coordinate reference system (CRS). Default value is set to \verb{CRS 25833}.}
}
\value{
Object with coordinates to the supplied addresses.
}
\description{
The function \code{address_to_coords} can be used to find coordinates to supplied Norwegian addresses. Internet access is required as the function utilizes \href{https://ws.geonorge.no/adresser/v1/}{the Norwegian Mapping Authority’s address API}.
}
\details{
If there are no coordinates found for the supplied address it means that it does not exist in \href{https://www.kartverket.no/eiendom/eiendomsgrenser/matrikkelen-norgeseiendomsregister}{Matrikkelen} - Norway's official property register. See \href{https://www.rettikartet.no/app/veger}{www.rettikartet.no} to search for existing addresses.
}
\examples{
address_to_coords(zip_code = "0185", address = "Schweigaards gate 10")

}
