% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_leaflet.R
\encoding{UTF-8}
\name{path_leaflet}
\alias{path_leaflet}
\title{Visualize the shortest path with Leaflet}
\usage{
path_leaflet(path, graph_object = graph)
}
\arguments{
\item{path}{Object (\code{list}) that has been created with the function \code{\link[=shortest_path_igraph]{shortest_path_igraph()}}, where \code{path = TRUE}.}

\item{graph_object}{The road network structured as a tidy graph (\code{tbl_graph} object). This can be done with the function \code{\link[=vegnett_to_R]{vegnett_to_R()}}.}
}
\value{
Interactive Leaflet map that shows the shortest path (in minutes or meters) between a chosen from and to node in the road network.
}
\description{
The function \code{path_leaflet} visualizes the shortest path (in minutes or meters) that has been calculated with the function \code{\link[=shortest_path_igraph]{shortest_path_igraph()}} (where \code{path = TRUE}).
Internet connection is required to load the background tiles.
}
\examples{

shortest_path_igraph(from_node_ID = 25,
                             to_node_ID = 33,
                             unit = "minutes",
                             path = TRUE,
                             graph_object = graph_sampledata) \%>\%
                             path_leaflet(graph_object = graph_sampledata)

}
