% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMod.R
\name{writeMod}
\alias{writeMod}
\alias{writeMod,ANY-method}
\title{Writes Stan code for GPP model}
\usage{
writeMod(noise, ncov, printMod = FALSE)
}
\arguments{
\item{noise}{The desired amount of artificial noise to add to the model.}

\item{ncov}{The number of covariates to include in the model.}

\item{printMod}{Boolean. Defaults FALSE. If TRUE, prints each model block to the console. See details.}
}
\value{
A string of Stan code that can be run with \code{\link{runMod}}
}
\description{
Returns string of Stan code that can be run to estimate the GPP.
}
\details{
We recommend keeping printMod as FALSE, otherwise, the function will write the model to the console for every model run on the convergence.
}
\examples{
\donttest{
writeMod(noise = 0.25, ncov = 2)
}
}
\seealso{
\code{\link{plotGPPfit}} \code{\link{runMod}} \code{\link{GPP}} \code{\link{autoConverge}}
}
\author{
Devin P. Brown \email{devinpbrown96@gmail.com} and David Carlson \email{carlson.david@wustl.edu}
}
