% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{get_all_config}
\alias{get_all_config}
\title{Print Plot and Export Configuration Snippets}
\usage{
get_all_config(
  plot_style = "default",
  plot_config = TRUE,
  export_config = TRUE
)
}
\arguments{
\item{plot_style}{Character. Plot style to use (currently only `"default"` is supported).}

\item{plot_config}{Logical. If `TRUE`, prints the plot style configuration.}

\item{export_config}{Logical. If `TRUE`, prints the export configuration.}
}
\value{
A named list containing the current default values for all GTAPViz configuration options,
including plot styles, table formats, and export parameters.
}
\description{
Retrieve full configuration code as a list for applying in the plot styling and export settings.
}
\details{
Onece printing into the console, users can simply copy and paste
the entire list of configurations, rename it (if needed), and use it in your plot functions directly.
}
\examples{
# Input Path:
input_path <- system.file("extdata/in", package = "GTAPViz")
sl4.plot.data <- readRDS(file.path(input_path, "sl4.plot.data.rds"))

# Retrive configurations
get_all_config()

}
\author{
Pattawee Puangchit
}
