% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{report_table}
\alias{report_table}
\title{Generate a Structured Report Table}
\usage{
report_table(
  data_list,
  pivot_col,
  total_column = FALSE,
  export_table = FALSE,
  separate_file = FALSE,
  output_path = NULL,
  sheet_names = NULL,
  include_units = FALSE,
  component_exclude = NULL,
  group_by = NULL,
  rename_cols = NULL,
  var_name_by_description = TRUE,
  add_var_info = FALSE,
  decimal = 2,
  unit_select = NULL,
  separate_sheet_by = NULL,
  subtotal_level = FALSE,
  repeat_label = FALSE,
  workbook_name = "detail_results",
  add_group_line = FALSE
)
}
\arguments{
\item{data_list}{A named list of data frames to process.}

\item{pivot_col}{A named list specifying the column to pivot into a wide format for each dataset.
Each dataset can have only one pivot column. Example:
\code{pivot_col = list(A = "COLUMN", E1 = "PRICES")}}

\item{total_column}{Logical. If \code{TRUE}, adds a "Total" column summing numeric values.}

\item{export_table}{Logical. If \code{TRUE}, saves the output as an Excel file.}

\item{separate_file}{Logical. If \code{TRUE}, saves each dataset as a separate Excel file.}

\item{output_path}{Character. Directory for saving Excel files when \code{export_table = TRUE}.}

\item{sheet_names}{Optional named list for custom sheet names.}

\item{include_units}{Logical. If \code{TRUE}, includes "Unit" as a grouping column if applicable.}

\item{component_exclude}{Optional character vector specifying pivoted values to exclude.}

\item{group_by}{A named list defining hierarchical grouping for each dataset. The order of columns
in each list determines the priority. Example:
\code{group_by = list(A = list("Experiment", "REG"), E1 = list("Experiment", "REG", "COMM"))}}

\item{rename_cols}{A named list for renaming columns across \strong{all} datasets. Example:
\code{rename_cols = list("REG" = "Region", "COMM" = "Commodities", "Experiment" = "Scenario")}}

\item{var_name_by_description}{Logical. If \code{TRUE}, replaces variable codes with descriptions when available.}

\item{add_var_info}{Logical. If \code{TRUE}, appends variable codes in parentheses after descriptions.}

\item{decimal}{Numeric. Number of decimal places for rounding values.}

\item{unit_select}{Optional character. Specifies a unit to filter the dataset.}

\item{separate_sheet_by}{Optional column name to split sheets in Excel. If defined, each unique
value in the specified column gets its own sheet. Example: \code{separate_sheet_by = "Scenario"}.}

\item{subtotal_level}{Logical. If \code{TRUE}, includes all subtotal values; otherwise, keeps only \code{TOTAL} rows.}

\item{repeat_label}{Logical. If \code{TRUE}, repeats the first group column in exports for clarity.}

\item{workbook_name}{Character. Name of the Excel workbook (without extension).}

\item{add_group_line}{Logical. If \code{TRUE}, adds a thin line after each group in the exported table.}
}
\value{
If \code{export_table = TRUE}, tables are saved as Excel files.
}
\description{
Transforms multiple datasets into wide-format tables based on defined pivot columns,
hierarchical grouping, and renaming rules. Supports optional subtotal filtering
and exporting to Excel.
}
\details{
This function requires a data list and can generate multiple output tables in a single setup.
That is, all data frames within the list can be processed simultaneously.
See the example for how to generate two data frames at once from the data list \code{sl4.plot.data},
which is obtained via \code{auto_gtap_data(plot_data = TRUE)}.
}
\examples{
\donttest{
# Load Data:
input_path <- system.file("extdata/in", package = "GTAPViz")
sl4.plot.data <- readRDS(file.path(input_path, "sl4.plot.data.rds"))

report_table(
  data_list = sl4.plot.data,

  # === Table Structure ===
  pivot_col = list(
    REG = "Variable",
    "COMM*REG" = "Commodity"
  ),
  group_by = list(
    REG = list("Experiment", "Region"),
    "COMM*REG" = list("Experiment", "Variable", "Region")
  ),
  rename_cols = list("Experiment" = "Scenario"),

  # === Table Layout & Labels ===
  total_column = FALSE,
  decimal = 4,
  subtotal_level = FALSE,
  repeat_label = FALSE,
  include_units = TRUE,
  var_name_by_description = TRUE,
  add_var_info = TRUE,
  add_group_line = FALSE,

  # === Export Options ===
  separate_sheet_by = "Unit",
  export_table = FALSE,
  output_path = NULL,
  separate_file = FALSE,
  workbook_name = "Comparison Table Default"
  )
}
}
\seealso{
\code{\link{add_mapping_info}}, \code{\link{convert_units}}, \code{\link{rename_value}},
\code{\link{pivot_table_with_filter}}
}
\author{
Pattawee Puangchit
}
