% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_get_inflation_data.R
\name{gdfpd.get.inflation.data}
\alias{gdfpd.get.inflation.data}
\title{Downloads and read inflation data from github}
\usage{
gdfpd.get.inflation.data(inflation.index, do.cache)
}
\arguments{
\item{inflation.index}{Sets the inflation index to use for finding inflation adjusted values of all reports. Possible values: 'dollar' (default) or 'IPCA', the brazilian main inflation index.
When using 'IPCA', the base date is set as the last date found in the DFP dataset.}

\item{do.cache}{Logical for controlling to whether to use a cache system or not. Default = TRUE}
}
\value{
A dataframe with inflation data
}
\description{
Inflation data is available at git repo 'msperlin/GetITRData_auxiliary'
}
\examples{

\dontrun{ # keep cran check fast
df.inflation <- gdfpd.get.inflation.data('IPCA')
str(df.inflation)
}
}
