% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau}
\alias{get.tau}
\title{generalized version of \code{get.tau}}
\usage{
get.tau(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  comparison.type = "representative",
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix with columns x, y and any other named columns
columns needed by fun}

\item{fun}{a function that takes in two rows of posmat and returns:
\enumerate{
     \item for pairs included in the numerator (and the denominator for independent data)
     \item for pairs that should only be included in the denominator
     \item for pairs that should be ignored all together}
Note that names from \code{posmat} are not preserved in calls to
\code{fun}, so the columns of the matrix should be referenced numerically
so this is not available to fun}

\item{r}{the series of spatial distances (or there maximums) we are
interested in}

\item{r.low}{the low end of each range, 0 by default}

\item{comparison.type}{what type of points are included in the comparison set.
\itemize{
  \item "representative" if comparison set is representative of the underlying population
  \item "independent" if comparison set is cases/events coming from an indepedent process
}}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
The tau value for each distance we look at. If \code{comparison.type} is "representative", this is:

\code{tau = get.pi(posmat, fun, r, r.low)/get.pi(posmat,fun,infinity,0)}

If \code{comparison.type} is "independent", this is:

\code{tau = get.theta(posmat, fun, r, r.low)/get.theta(posmat,fun,infinity,0)}
}
\description{
returns the relative probability (or odds) that points at some distance
from an index point share some relationship with that point versus
the probability (or odds) any point shares that relationship with that point.
}
\examples{
\donttest{

data(DengueSimR01)
data(DengueSimR02)
data(DengueSimRepresentative)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)
r.mid<-(r.max+r.min)/2

sero.type.func<-function(a,b,tlimit=20){
     if(a[5]==b[5]&(abs(a[3]-b[3])<=tlimit)){rc=1}
     else{rc=2}
     return(rc)
}

geno.type.func<-function(a,b,tlimit=20){
     if(a[4]==b[4]&(abs(a[3]-b[3])<=tlimit)){rc=1}
     else{rc=2}
     return(rc)
}

sero.type.rep.func<-function(a,b,tlimit=20){
     if(a[5]==1&b[5]==1&(abs(a[3]-b[3])<=tlimit)){rc=1}
     else{if(a[5]==1&b[5]==-999){rc=2}else{rc=3}}
     return(rc)
}

sero.tau.R01 <- get.tau(DengueSimR01, sero.type.func, r=r.max, r.low=r.min, 
                      comparison.type="independent")
geno.tau.R01 <- get.tau(DengueSimR01, geno.type.func, r=r.max, r.low=r.min, 
                      comparison.type="independent")

sero.tau.R02 <- get.tau(DengueSimR02, sero.type.func, r=r.max, r.low=r.min, 
                      comparison.type="independent")
geno.tau.R02 <- get.tau(DengueSimR02, geno.type.func, r=r.max, r.low=r.min, 
                      comparison.type="independent")

sero.tau.representative <- get.tau(DengueSimRepresentative, sero.type.rep.func, 
                                   r=r.max, r.low=r.min, comparison.type="representative")

## R0 of 1
plot(r.mid,sero.tau.R01$tau,ylim=c(0.3,max(geno.tau.R01$tau)),log="y",
     cex.axis=1.25,col=rgb(t(col2rgb("blue")/255),alpha=0.6),
     xlab="Distance (m)",ylab="Tau",cex.main=0.9,lwd=2,type="l",las=1,cex.axis=0.75)
abline(h=1,lty=2)

abline(v=100,lty=1,lwd=2)
lines(r.mid,geno.tau.R01$tau,pch=20,col=rgb(t(col2rgb("dark green")/255),alpha=0.6),lwd=1)
lines(r.mid,sero.tau.representative$tau,pch=20,col=rgb(t(col2rgb("dark blue")/255),alpha=0.6),lty=2)
legend("topright",
       legend=c("Genotype",
                "Serotype",
                "Serotype (representative population)",
                "Maximum transmission distance"),
       lwd=1,col=c("dark green","blue","blue","black"),
       lty=c(1,1,2,1),bty="n")

## R0 of 2
plot(r.mid,sero.tau.R02$tau,ylim=c(0.3,max(geno.tau.R02)),log="y",
     cex.axis=1.25,col=rgb(t(col2rgb("blue")/255),alpha=0.6),
     xlab="Distance (m)",ylab="Tau",cex.main=0.9,lwd=2,type="l",las=1,cex.axis=0.75)
abline(h=1,lty=2)
abline(v=100,lty=1,lwd=2)
lines(r.mid,geno.tau.R02$tau,pch=20,col=rgb(t(col2rgb("dark green")/255),alpha=0.6),lwd=1)
legend("topright",
       legend=c("Genotype",
                "Serotype",
                "Maximum transmission distance"),
       lwd=1,col=c("dark green","blue","black"),lty=1,bty="n")

}
}
\seealso{
Other get.tau: 
\code{\link{get.tau.bootstrap}()},
\code{\link{get.tau.ci}()},
\code{\link{get.tau.permute}()},
\code{\link{get.tau.typed}()},
\code{\link{get.tau.typed.bootstrap}()},
\code{\link{get.tau.typed.permute}()}

Other spatialtau: 
\code{\link{get.pi}()},
\code{\link{get.theta}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.tau}
\concept{spatialtau}
