% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImNN.R
\name{ImNN}
\alias{ImNN}
\title{Neural Networks for Predicting Volume of Forest Trees}
\usage{
ImNN(data, hidden_neurons_range)
}
\arguments{
\item{data}{Datasets}

\item{hidden_neurons_range}{Number of hidden neurons in neural network's two layers (layer 1 and layer 2)}
}
\value{
\itemize{
  \item results: Results
}
}
\description{
Neural Networks for Predicting Volume of Forest Trees
}
\examples{
\donttest{
library("ImNN")
data <- system.file("extdata", "data_test.csv", package = "ImNN")
data_test <- read.csv(data)
Model<-ImNN(data =data_test,hidden_neurons_range=2)
}
}
\references{
\itemize{
\item Jeelani, M.I., Tabassum, A., Rather, K and Gul,M.2023. Neural Network Modeling of Height Diameter Relationships for Himalayan Pine through Back Propagation Approach. Journal of The Indian Society of Agricultural Statistics. 76(3): 169–178
\item Tabassum, A., Jeelani, M.I., Sharma,M., Rather, K R ., Rashid, I and Gul,M.2022.  Predictive Modelling of Height and Diameter Relationships of Himalayan Chir Pine . Agricultural Science Digest - A Research Journal. DOI:10.18805/ag.D-5555
}
}
