% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fml2expr.R
\name{fml2expr}
\alias{fml2expr}
\title{Turn text with chemical formulas into expression vector.}
\usage{
fml2expr(x, expr = TRUE)
}
\arguments{
\item{x}{Character vector containing chemical formulas.}

\item{expr}{Will return vector of characters when FALSE and expressions when TRUE.}
}
\value{
A vector of expressions.
}
\description{
It is often helpful to annotate a Figure with chemical formulas.
    However, to increase readability of chemical formulas, certain conventions
    have to be met. These concern, among others, superscript and subscript 
    text which, in R, can only be provided via expressions. `fml2expr` will
    convert any character vector into an expression vector, aiming to identify
    and format potential contained chemical formulas.
}
\examples{
texts <- c(
  "C6H12Cl6",         # simple formula
  "H3Na",             # simple formula
  "Text with blank",  # simple text
  "A1B2",             # No valid elements but looks like formula
  "Fe(NO3)3",         # group with index
  "SO4^2-",           # charged molecule
  "Na+", "Cl-",       # simple ions
  paste0("H", intToUtf8(0x2082), "O"), # unicode-subscript
  "Ca(OH)2-"          # group with index and charge
)

# Check that all examples can be converted to expression
all(sapply(texts , function(x) { !inherits(try(fml2expr(x), silent=TRUE), "try-error") }))
exprs <- fml2expr(texts)
str(exprs)

# Plot with legend
plot(1:10, 1:10, pch = 16, col = 1:10, xlim = c(0, 11), ylim = c(0, 11))
legend("topright", legend = exprs, col = 1:10, pch = 16, title = "Formeln")

# Careful! text() does not accept an expression vector
text(3:4,3:4,labels=exprs[3:4])
for (i in 5:6) text(i,i,labels=exprs[[i]])

# you can also return a named character vector (names are input, values are modified)
fml2expr(texts, expr = FALSE)
}
