#' Compute shared nearest neighbors
#'
#' Builds a shared nearest neighbors matrix and,
#' for each row (observation), returns the indices of the top neighbors
#' with the largest SNN overlap counts
#'
#' @param z_dat A dataframe with numeric columns
#' @param k An integer representing number of nearest neighbors
#' @param tops An integer representing how many of shared nearest neighbors to return
#'
#' @returns A dataframe of top rows with shared nearest neighbors
#' @export
sim_SNN <- function(z_dat, k, tops){
  s <- tops
  SNN <- dbscan::sNN(z_dat, k, jp = FALSE, sort = FALSE, search = "dist", bucketSize = 10, approx = 0)
  SNN_id <- SNN$id
  temp_neighbor <- matrix(0, ncol = nrow(SNN_id), nrow = nrow(SNN_id))
  for(i in 1:(nrow(SNN_id)-1)){
    for(j in (i+1):(nrow(SNN_id))){
      temp_neighbor[i,j] = sum(SNN_id[i,] %in% SNN_id[j,])
    }
  }
  temp_neighbor = temp_neighbor + t(temp_neighbor)
  output = t(apply(temp_neighbor, FUN = function(x){
    return(order(x, decreasing = T)[1:s])
  }, MARGIN = 1))
  return(output)
}



