% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object-fa-like.R
\name{fa_like}
\alias{fa_like}
\title{Create a Factor Analysis-like low rank matrix factorization object}
\usage{
fa_like(Z, B, Y, subclasses = NULL, ...)
}
\arguments{
\item{Z}{A \emph{matrix} of embeddings for each observation.}

\item{B}{A mixing \emph{matrix} describing how observation embeddings
and topics interact. Does not have to be diagonal!}

\item{Y}{A \emph{matrix} describing the compositions of various topics
or factors.}

\item{subclasses}{A character vector of subclasses.
Optional, defaults to \code{NULL}.}

\item{...}{Optional additional items to pass to the constructor.}
}
\description{
A low rank matrix factorization of a matrix \code{X} is
parameterized by \verb{X ~= X \%*\% B \%*\% t(Y)}. The
object is "factor analysis-like" because the middle
matrix in the decomposition is arbitrary rather than
diagonal.
}
\examples{

s <- svd(as.matrix(trees))

fa_like(s$u, diag(s$d), s$v)

}
