% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSD.msdplot.r
\name{msdplot}
\alias{msdplot}
\alias{LSD.msdplot}
\title{Visualize two-dimensional data clusters}
\usage{
msdplot(
  input,
  label = NULL,
  at = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "",
  ylab = "",
  main = "msdplot",
  xaxt = "s",
  xlabels = NULL,
  las = 1,
  separate = TRUE,
  size = TRUE,
  col = "darkgreen",
  bars = TRUE,
  alpha = 50,
  ...
)
}
\arguments{
\item{input}{matrix or list with numerical entries, quantiles of cols will define lines.}

\item{label}{a character vector assigning rows/elements of 'input' to clusters (if specified, multiple clusters can be depicted in different colors and/or subsequent plots).}

\item{at}{a integer vector containing the x-positions corresponding to the columns of 'input'.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{xlab}{x labels, standard graphics parameter.}

\item{ylab}{y labels, standard graphics parameter.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{xaxt}{a character which specifies the x axis type ("n" suppresses plotting of the axis).}

\item{xlabels}{a character vector containing labels for the x-axis.}

\item{las}{las=1: horizontal text, las=2: vertical text (x-axis labels).}

\item{separate}{if \code{TRUE} (by default), different clusters are depicted in subsequent plots.}

\item{size}{logical: if \code{TRUE} (by default), the size of each cluster is added to the title of the respective plot.}

\item{col}{a character vector giving R build-in colors for different clusters.}

\item{bars}{logical: if \code{TRUE} (by default), error bars are added at each position.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Depict a numeric matrix or list utilizing the underlying mean and standard deviation estimates of one dimension in a color encoded fashion.
}
\examples{
at = c(2,4,8,16,32)
clus = matrix(rnorm(500,sd=0.5),ncol=5)
batch = sample(c(-8,-6,-4,-2),100,replace=TRUE)
clus = clus + cbind(0,0.25*batch,0.5*batch,0.75*batch,batch)
clus = clus - clus[,1]
clus = t(t(clus)*c(0,0.1,0.25,0.5,1))
labs = paste("cluster",kmeans(clus,4)$cluster)

colpal = c("darkgreen","darkblue","darkred","black")
msdplot(clus,labs,at,separate=FALSE,col=colpal,alpha=25,xlabels=at)

msdplot(clus,labs,at,col=colpal,alpha=50,xlabels=at)
}
\seealso{
\code{\link{comparisonplot}}, \code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\author{
Bjoern Schwalb
}
\keyword{mean}
\keyword{sd}
