% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{pad0}
\alias{pad0}
\title{Pad a vector with 0 to a desired length}
\usage{
pad0(v, l, value = 0, start = 0, value.start = 0)
}
\arguments{
\item{v}{the vector to pad with 0}

\item{l}{the desired (resulting) length of the vector}

\item{value}{the value to pad with (if padding is needed). Default to 0, but
can be overridden to pad with any other value.}

\item{start}{the first \code{start} values are always set to 0 (default is 0,
can be changed using the \code{value.start} argument),
the vector \code{v} starts only after these leading zeroes. The number of
leading zeroes counts towards the desired length}

\item{value.start}{the value to insert before the start index.}
}
\value{
returns the vector \code{v} padded to length \code{l} with value \code{value} (default 0).
}
\description{
Pad a vector with 0 to a desired length
}
\examples{
pad0(1:5, 7)   # Pad to length 7 with zeroes
pad0(1:5, 3)   # no padding, but cut at length 3

# 3 leading zeroes, then the vector start (10 elements of vector, no additional padding needed):
pad0(1:10, 13, start = 3)

# padding with value other than zero:
pad0(1:5, 7, value = "pad")
}
