% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epochs.R
\name{count_difftime}
\alias{count_difftime}
\title{Counts the Time differences (epochs) per group (in a grouped dataset)}
\usage{
count_difftime(dataset, Datetime.colname = Datetime)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the
\code{Datetime.colname}.}

\item{Datetime.colname}{column name that contains the datetime. Defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}. Expects a \code{symbol}. Needs to be part of the \code{dataset}. Must
be of type \code{POSIXct}.}
}
\value{
a \code{tibble} with the number of occurences of each time difference per
group
}
\description{
Counts the Time differences (epochs) per group (in a grouped dataset)
}
\examples{
#count_difftime returns the number of occurences of each time difference
#and is more comprehensive in terms of a summary than `gap_finder` or 
#`dominant_epoch`
count_difftime(sample.data.irregular)
dominant_epoch(sample.data.irregular)
gap_finder(sample.data.irregular)

#irregular data can be regularized with `aggregate_Datetime`
sample.data.irregular |> 
 aggregate_Datetime(unit = "15 secs") |> 
 count_difftime()
}
