% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{format_coordinates}
\alias{format_coordinates}
\title{Format coordinates as a readable string}
\usage{
format_coordinates(coordinates, digits = 1)
}
\arguments{
\item{coordinates}{A numeric vector of length two with latitude as the first
element and longitude as the second element.}

\item{digits}{Integerish scalar defining the number of decimal places used
for rounding. Defaults to one decimal place.}
}
\value{
A character scalar with the formatted coordinate string.
}
\description{
Create a concise latitude/longitude label (e.g., \eqn{48.5^\circ N, 9.1^\circ
E}) from a two element coordinate vector.
}
\examples{
# Coordinates for Tuebingen, Germany
format_coordinates(c(48.5216, 9.0576))

}
