% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_frequency_crossing_threshold.R
\name{frequency_crossing_threshold}
\alias{frequency_crossing_threshold}
\title{Frequency of crossing light threshold}
\usage{
frequency_crossing_threshold(
  Light.vector,
  threshold,
  na.rm = FALSE,
  as.df = FALSE
)
}
\arguments{
\item{Light.vector}{Numeric vector containing the light data.}

\item{threshold}{Single numeric value specifying the threshold light level to compare with.}

\item{na.rm}{Logical. Should missing light values be removed? Defaults to \code{FALSE}.}

\item{as.df}{Logical. Should the output be returned as a data frame? If \code{TRUE}, a data
frame with a single column named \verb{frequency_crossing_\{threshold\}} will be returned.
Defaults to \code{FALSE}.}
}
\value{
Data frame or matrix with pairs of threshold and calculated values.
}
\description{
This functions calculates the number of times a given threshold
light level is crossed.
}
\examples{
N = 60
dataset1 <-
  tibble::tibble(
    Id = rep("A", N),
    Datetime = lubridate::as_datetime(0) + lubridate::minutes(1:N),
    MEDI = sample(c(sample(1:249, N / 2), sample(250:1000, N / 2))),
  )

dataset1 \%>\%
  dplyr::reframe("Frequency crossing 250lx" = frequency_crossing_threshold(MEDI, threshold = 250))

dataset1 \%>\%
  dplyr::reframe(frequency_crossing_threshold(MEDI, threshold = 250, as.df = TRUE))

}
\references{
Alvarez, A. A., & Wildsoet, C. F. (2013). Quantifying light
exposure patterns in young adult students. \emph{Journal of Modern Optics},
60(14), 1200–1208. \doi{10.1080/09500340.2013.845700}

Hartmeyer, S.L., Andersen, M. (2023). Towards a framework for light-dosimetry studies:
Quantification metrics. \emph{Lighting Research & Technology}.
\doi{10.1177/14771535231170500}
}
\seealso{
Other metrics: 
\code{\link{bright_dark_period}()},
\code{\link{centroidLE}()},
\code{\link{disparity_index}()},
\code{\link{dose}()},
\code{\link{duration_above_threshold}()},
\code{\link{exponential_moving_average}()},
\code{\link{interdaily_stability}()},
\code{\link{intradaily_variability}()},
\code{\link{midpointCE}()},
\code{\link{nvRC}()},
\code{\link{nvRD}()},
\code{\link{nvRD_cumulative_response}()},
\code{\link{period_above_threshold}()},
\code{\link{pulses_above_threshold}()},
\code{\link{threshold_for_duration}()},
\code{\link{timing_above_threshold}()}
}
\concept{metrics}
