# Automatically connect adjacent markers.

# Create data frame of information to automatically connect markers
#     of the same name on adjacent linkage groups in the same row
#
#
# Input: A list of linkage group data
#
# Returns: A data frame containing one row for every connection to
#    drawn between homologs (markers of the same name on adjacent
#    linkage groups).

autoconn <-
  function(lg, fg, lgperrow) {
    conndf <- data.frame(
      fromchr = character(),
      fromlocus = character(),
      tochr = character(),
      tolocus = character(),
      col = character(),
      stringsAsFactors = FALSE
    )

    # first remove any "(## more)" labels generated by dupnbr=TRUE
    newlg <- list()
    for (i in 1:length(lg)) {
      morelab <- lg[[i]]$locus[grep("more)", lg[[i]]$locus)]
      newlg[[i]] <-
        subset(lg[[i]],!(lg[[i]]$locus %in% morelab) &
                 !(lg[[i]]$locus == ""))
    }

    # next pick out the from
    if (length(newlg) > 1) {
      for (i in 2:length(newlg)) {
        # if no locus labels at all skip it (density map)
        if (nrow(newlg[[i - 1]]) > 0 &
                 nrow(newlg[[i]]) > 0) {
          # don't connect if for some reason they requested
          # the same linkage group side by side
          # or if they are going to be in different rows
          if (!(newlg[[i - 1]][1, 1] == newlg[[i]][1, 1])
              && (i - 1) %% lgperrow != 0) {
            connlocus <-
              newlg[[i - 1]]$locus[newlg[[i - 1]]$locus %in% newlg[[i]]$locus]
            if (length(connlocus) > 0) {
              conndf <- rbind(
                conndf,
                data.frame(
                  fromchr = newlg[[i - 1]][1, 1],
                  fromlocus = connlocus,
                  tochr = newlg[[i]][1, 1],
                  tolocus = connlocus,
                  col = fg
                )
              )
            }
          }
        }
      }
    }
    return (conndf)
  }
