% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LncFinder.R
\name{build_model}
\alias{build_model}
\title{Build Users' Own Model}
\usage{
build_model(
  lncRNA.seq,
  mRNA.seq,
  frequencies.file,
  SS.features = FALSE,
  lncRNA.format = "DNA",
  mRNA.format = "DNA",
  parallel.cores = 2,
  folds.num = 10,
  seed = 1,
  gamma.range = (2^seq(-5, 0, 1)),
  cost.range = c(1, 4, 8, 16, 24, 32),
  ...
)
}
\arguments{
\item{lncRNA.seq}{Long non-coding sequences. Can be a FASTA file loaded by
\code{\link[seqinr]{seqinr-package}} or secondary structure
sequences file (Dot-Bracket Notation) obtained from function
\code{\link{run_RNAfold}}. If \code{lncRNA.seq} is secondary structure
sequences file, parameter \code{lncRNA.format} should be defined as \code{"SS"}.}

\item{mRNA.seq}{mRNA sequences. FASTA file loaded by \code{\link[seqinr]{read.fasta}} or
secondary structure sequences (Dot-Bracket Notation) obtained from function
\code{\link{run_RNAfold}}. If \code{mRNA.seq} is secondary structure sequences
file, parameter \code{mRNA.format} should be defined as \code{"SS"}.}

\item{frequencies.file}{String or a list obtained from function
\code{\link{make_frequencies}}. Input species name \code{"human"},
\code{"mouse"} or \code{"wheat"} to use pre-build frequencies files. Or assign
a users' own frequencies file (Please refer to function
\code{\link{make_frequencies}} for more information).}

\item{SS.features}{Logical. If \code{SS.features = TRUE}, secondary structure
features will be used to build the model. In this case, \code{lncRNA.seq} and
\code{mRNA.seq} should be secondary structure sequences (Dot-Bracket Notation)
obtained from function \code{\link{run_RNAfold}} and parameter
\code{lncRNA.format} and \code{mRNA.format} should be set as \code{"SS"}.}

\item{lncRNA.format}{String. Define the format of \code{lncRNA.seq}. \code{"DNA"}
for DNA sequences and \code{"SS"} for secondary structure sequences. Only when
both \code{mRNA.format} and \code{lncRNA.format} are set as \code{"SS"}, can
the model with secondary structure features be built (\code{SS.features = TRUE}).}

\item{mRNA.format}{String. Define the format of \code{mRNA.seq}. Can be
\code{"DNA"} or \code{"SS"}. \code{"DNA"} for DNA sequences and \code{"SS"}
for secondary structure sequences. When this parameter is defined as \code{"DNA"},
only the model without secondary structure features can be built. In this case,
parameter \code{SS.features} should be set as \code{FALSE}.}

\item{parallel.cores}{Integer. The number of cores for parallel computation.
By default the number of cores is \code{2}, users can set as \code{-1} to run
this function with all cores. During the process of svm tuning, if the number
of \code{parallel.cores} is more than the \code{folds.num} (number of the folds
for cross-validation), the number of \code{parallel.cores} will be set as
\code{folds.num} automatically.}

\item{folds.num}{Integer. Specify the number of folds for cross-validation.
(Default: \code{10})}

\item{seed}{Integer. Used to set the seed for cross-validation. (Default: \code{1})}

\item{gamma.range}{The range of gamma. (Default: \code{2 ^ seq(-5, 0, 1)})}

\item{cost.range}{The range of cost. (Default: \code{c(1, 4, 8, 16, 24, 32)})}

\item{...}{Additional arguments passed to function \code{\link{svm_tune}} for customised SVM model training.}
}
\value{
Returns a svm model.
}
\description{
This function is used to build new models with users' own data.
}
\details{
This function is used to build a new model with users' own sequences.
Users can use function \code{\link{lnc_finder}} to predict the sequences with
new models.

For the details of \code{frequencies.file}, please refer to function
\code{\link{make_frequencies}}.

For the details of the features, please refer to function
\code{\link{extract_features}}.

For the details of svm tuning, please refer to function \code{\link{svm_tune}}.
}
\section{References}{

Siyu Han, Yanchun Liang, Qin Ma, Yangyi Xu, Yu Zhang, Wei Du, Cankun Wang & Ying Li.
LncFinder: an integrated platform for long non-coding RNA identification utilizing
sequence intrinsic composition, structural information, and physicochemical property.
\emph{Briefings in Bioinformatics}, 2019, 20(6):2009-2027.
}

\examples{
\dontrun{
data(demo_DNA.seq)
Seqs <- demo_DNA.seq

### Build the model with pre-build frequencies.file:
my_model <- build_model(lncRNA.seq = Seqs[1:5], mRNA.seq = Seqs[6:10],
                        frequencies.file = "human", SS.features = FALSE,
                        lncRNA.format = "DNA", mRNA.format = "DNA",
                        parallel.cores = 2, folds.num = 2, seed = 1,
                        gamma.range = (2 ^ seq(-5, -1, 2)),
                        cost.range = c(2, 6, 12, 20))

### Users can use default values of gamma.range and cost.range to find the
### best parameters.
### Use your own frequencies file by assigning frequencies list to parameter
### "frequencies.file".
}
}
\seealso{
\code{\link{make_frequencies}}, \code{\link{lnc_finder}},
         \code{\link{extract_features}}, \code{\link{svm_tune}},
         \code{\link[e1071]{svm}}.
}
\author{
HAN Siyu
}
