% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA-suggestions.R
\name{Lorenz.Suggestions}
\alias{Lorenz.Suggestions}
\title{Defines the suggestions used in the genetic algorithm}
\usage{
Lorenz.Suggestions(suggestions, popSize, y, x, pi, x.scale, seed)
}
\arguments{
\item{suggestions}{either a character string 'OLS' or a numeric matrix with at most \code{popSize} rows and \code{ncol(x)} columns.}

\item{popSize}{population size of the genetic algorithm}

\item{y}{vector of responses}

\item{x}{matrix of covariates (after standardization if applied)}

\item{pi}{vector of normalized weights}

\item{x.scale}{vector of standard deviations of the covariates}

\item{seed}{seed used in the generation of the suggestions}
}
\value{
A matrix with at most \code{popsize} rows and with a number of columns equal to the number of explanatory variables minus one.
}
\description{
\code{Lorenz.Suggestions} creates suggestions for the genetic algorithm used to solve the Lorenz regression.
}
\seealso{
\code{\link{Lorenz.GA}}
}
\keyword{internal}
