% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-plot.R
\name{autoplot.PLR}
\alias{autoplot.PLR}
\alias{plot.PLR}
\alias{autoplot.PLR_boot}
\alias{plot.PLR_boot}
\alias{autoplot.PLR_cv}
\alias{plot.PLR_cv}
\title{Plots for the penalized Lorenz regression}
\usage{
\method{autoplot}{PLR}(
  object,
  type = c("explained", "traceplot", "diagnostic", "residuals"),
  traceplot.which = "BIC",
  pars.idx = "BIC",
  score.df = NULL,
  band.level = 0.95,
  palette = NULL,
  ...
)

\method{plot}{PLR}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}

\item{type}{A character string indicating the type of plot. Possible values are \code{"explained"}, \code{"traceplot"} and \code{"diagnostic"}.
\itemize{
\item If \code{"explained"} is selected, the graph displays the Lorenz curve of the response and concentration curve of the response with respect to the estimated index. The grid and penalty parameters used to estimate the index are chosen via the \code{pars.idx} argument.
If \code{object} inherits from \code{"PLR_boot"} and \code{LC_store} was set to \code{TRUE} in \code{\link{Lorenz.boot}}, pointwise confidence intervals for the concentration curve are added. Their confidence level is set via the argument \code{band.level}.
\item If \code{"traceplot"} is selected, the graph displays a traceplot, where the horizontal axis is -log(lambda), lambda being the value of the penalty parameter. The vertical axis gives the value of the estimated coefficient attached to each covariate.
\item If \code{"diagnostic"} is selected, the graph displays a faceted plot, where each facet corresponds to a different value of the grid parameter. Each plot shows the evolution of the scores of each available selection method. For comparability reasons, the scores are normalized such that the larger the better and the optimum is attained in 1.
\item If \code{"residuals"} is selected, the graph displays a scatterplot of residuals with respect to the estimated index.
The grid and penalty parameters used for estimation are chosen via the \code{pars.idx} argument.
Obtaining residuals entail to estimate the link function of the single-index. This is performed via the function \code{\link{Rearrangement.estimation}}, as explained in \code{\link{predict.LR}}.
}}

\item{traceplot.which}{This argument indicates the value of the grid parameter for which the traceplot should be produced (see arguments \code{grid.value} and \code{grid.arg} in function \code{\link{Lorenz.Reg}}).
It can be an integer indicating the index in the grid determined via \code{grid.value}.
Alternatively, it can be a character string indicating the selection method. In this case the index corresponds to the optimal value according to that selection method.}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default) - Always available.
   \item \code{"Boot"} - Available if \code{object} inherits from \code{"PLR_boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{score.df}{A data.frame providing the scores to be displayed if \code{type} is set to \code{"diagnostic"}. For internal use only.}

\item{band.level}{Confidence level for the bootstrap confidence intervals.}

\item{palette}{A vector of colors. If \code{NULL} (default), the base R
palette is used. When provided, the first color is reserved for the baseline
(typically "black"), and the remaining colors are used to distinguish the curves.}

\item{...}{Additional arguments passed either to \code{\link{Lorenz.graphs}} (for \code{type = "explained"})
or to \code{\link{fitted.PLR}} and \code{\link{residuals.PLR}} (for \code{type = "residuals"}).}

\item{x}{An object of class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}
}
\value{
\code{autoplot} returns a \code{ggplot} object representing the desired graph. \code{plot} directly displays this plot.
}
\description{
\code{autoplot} generates summary plots for an object of class \code{"PLR"} and returns them as \code{ggplot} objects.
The \code{plot} method is a wrapper around \code{autoplot} that directly displays the plot,
providing a more familiar interface for users accustomed to base R plotting.
}
\details{
The available selection methods depend on the classes of the object: BIC is always available, bootstrap is available if \code{object} inherits from \code{"PLR_boot"}, cross-validation is available if \code{object} inherits from \code{"PLR_cv"}
}
\examples{
## For examples see example(Lorenz.Reg), example(Lorenz.boot) and example(PLR.CV)

}
\seealso{
\code{\link{Lorenz.Reg}}
}
