% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-coef.R
\name{coef.PLR}
\alias{coef.PLR}
\alias{coef.PLR_boot}
\alias{coef.PLR_cv}
\title{Estimated coefficients for the penalized Lorenz regression}
\usage{
\method{coef}{PLR}(object, renormalize = TRUE, pars.idx = "BIC", ...)
}
\arguments{
\item{object}{An object of S3 class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}

\item{renormalize}{A logical value determining whether the coefficient vector should be re-normalized to match the representation where the first category of each categorical variable is omitted. Default value is TRUE}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default) - Always available.
   \item \code{"Boot"} - Available if \code{object} inherits from \code{"PLR_boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{...}{Additional arguments}
}
\value{
a vector gathering the estimated coefficients.
}
\description{
Provides the estimated coefficients for an object of class \code{"PLR"}.
}
\examples{
## For examples see example(Lorenz.Reg), example(Lorenz.boot) and example(PLR.CV)

}
\seealso{
\code{\link{Lorenz.Reg}}
}
