% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultaneous.R
\name{plot.MAMS.stepdown}
\alias{plot.MAMS.stepdown}
\title{Plot method for MAMS.stepdown objects}
\usage{
\method{plot}{MAMS.stepdown}(
  x,
  col = NULL,
  pch = NULL,
  lty = NULL,
  main = NULL,
  xlab = "Analysis",
  ylab = "Test statistic",
  ylim = NULL,
  type = NULL,
  bty = "n",
  las = 1,
  ...
)
}
\arguments{
\item{x}{An output object of class MAMS.stepdown}

\item{col}{A specification for the default plotting color (default=\code{NULL}).
See \code{par} for more details.}

\item{pch}{Either an integer specifying a symbol or a single character to be
used as the default in plotting points (default=\code{NULL}). See \code{par}
for more details.}

\item{lty}{A specification for the default line type to be used between
analyses (default=\code{NULL}). Setting to zero suppresses plotting of the
lines. See \code{par} for more details.}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab}{A title for the x axis (default=\code{"Analysis"}).}

\item{ylab}{A title for the y axis (default=`"Test statistic"``).}

\item{ylim}{A title for the y axis (default=\code{"Test statistic"}).}

\item{type}{Type of plot to be used (default=\code{NULL}). See \code{plot}
for more details.}

\item{bty}{Should a box be drawn around the legend? The default \code{"n"}
does not draw a box, the alternative option \code{"o"} does.}

\item{las}{A specification of the axis labeling style. The default \code{1}
ensures the labels are always horizontal. See \code{?par} for details.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Graphic output.
}
\description{
produces as plot of the boundaries.
}
\examples{
\donttest{
# 2-stage design with triangular boundaries
res <- mams(K=4, J=2, alpha=0.05, power=0.9, r=1:2, r0=1:2,
 p=0.65, p0=0.55, ushape="triangular", lshape="triangular", nstart=30)

plot(res)
}
}
\author{
Thomas Jaki, Dominique-Laurent Couturier
}
