% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probeInteraction.R
\name{probeInteraction}
\alias{probeInteraction}
\title{Probe interaction models}
\usage{
probeInteraction(
  object,
  antecedent,
  moderator,
  alpha = 0.05,
  JN = TRUE,
  n.interval.moderator,
  quantile.moderator,
  values.moderator
)
}
\arguments{
\item{object}{object of class \code{lm}.}

\item{antecedent}{antecedent (or x) variable in \code{object}.}

\item{moderator}{moderator variable in \code{object}.}

\item{alpha}{desired alpha level for Johnson-Neyman procedure.}

\item{JN}{indicate whether Johnson-Neyman procedure should be carried out.}

\item{n.interval.moderator}{number of intervals in the moderator variable to probe.}

\item{quantile.moderator}{quantile values in the moderator variable to probe.}

\item{values.moderator}{raw values in the moderator variable to probe.}
}
\value{
\code{probeInteraction} returns a data frame containing values of the moderator
in a linear model, the effect of the antecedent at that value of the moderator,
standard errors, t values, p values and a confidence interval.
}
\description{
Probe the effect of a moderator on an X/antecedent variable in a linear model.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
the arguments \code{n.interval.moderator}, \code{quantile.moderator} and \code{values.moderator}
can be combined. All unique values from these methods combined, together with the values from the
Johnson-Neyman procedure (if specified) will be part of the probing procedure.
}
\examples{
lm.1 <- lm(mpg ~ hp * wt, data = mtcars)
probeInteraction(lm.1, hp, wt, JN=TRUE, n.interval.moderator = 3,
                 quantile.moderator = c(0.1,0.9), values.moderator = 2)
}
\author{
Mathijs Deen
}
