% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.maps.sphere}
\alias{calc.maps.sphere}
\title{Estimate marker positions using spherically constrained weighted MDS}
\usage{
calc.maps.sphere(
  fname,
  p = 100,
  n = NULL,
  weightfn = "lod2",
  mapfn = "haldane"
)
}
\arguments{
\item{fname}{Character string specifying the base name of the file 
fname.txt which contains the data to be analysed. The file should be 
white space or tab separated.}

\item{p}{Integer - the penalty for deviations from the sphere - higher p 
forces points more closely onto a sphere.}

\item{n}{Vector of integers or strings containing markers to be omitted from 
the analysis.}

\item{weightfn}{Character string specifying the values to use for the weight 
matrix in the MDS 'lod2' or 'lod'.}

\item{mapfn}{Character string specifying the map function to use on the 
recombination fractions 'haldane' is default, 'kosambi' or 'none'.}
}
\value{
A list (S3 class 'spheremap') with the following elements:
\item{smacofsym}{The unconstrained wMDS results.}
\item{smacofsphere}{The spherically constrained wMDS results.}
\item{mapsphere}{Map of the markers onto an interval containing order-the 
rank of each marker.}
\item{distmap}{A symmetric matrix of pairwise distances between markers where 
the columns are in the estimated order.}
\item{lodmap}{A symmetric matrix of lod scores associated with the distances in distmap.}
\item{locimap}{A data frame of the markers containing the name of each marker, 
the number in the configuration plot if that is being used, the position of 
each marker in order of increasing distance and the nearest neighbour fit of 
the marker.}
\item{length}{Integer giving the total length of the segment.}
\item{removed}{A vector of the names of markers removed from the analysis.}
\item{locikey}{A data frame showing the number associated with each marker 
name for interpreting the wMDS configuration plots.}
\item{stressratio}{The ratio of the constrained to unconstrained stress.}
\item{ssphere}{The stress per point of the spherically constrained wMDS.}
\item{ssym}{Stress per point of the unconstrained wMDS.}
\item{meannnfit}{The mean across all markers of the nearest neighbour fits.}
}
\description{
Reads a text file of pairwise recombination fractions and LOD scores, 
estimates marker positions using spherically constrained weighted MDS
}
\details{
This can be very slow with large sets of markers, in which case it may be 
better to consider \code{\link{calc.maps.pc}}.

Reads a file of the form described below and casts the data into matrices of 
pairwise recombination fractions and weights determined by the \code{weightfn} 
parameter (\code{LOD} or \code{LOD^2^}) calculates a distance matrix from the map 
function. Haldane is the default map function, None just uses recombination 
fractions and the other alternative is Kosambi (see \code{link{dmap}} 
for details). 

Performs both an unconstrained and dual spherically constrained weighted MDS 
on the distance matrix using \code{\link[smacof]{smacofSym}} and 
\code{\link[smacof]{smacofSphere}} (\cite{de Leeuw & Mair 2009}) 
and maps this to an interval (see \code{\link{map.to.interval}} for details).

Inevitably the constrained MDS has higher stress than the unconstrained MDS and 
a good rule of thumb is that this should not be more than about 10% higher.

File names should be of the form \code{fname.txt} and it is assumed that they are in 
a tab or space separated file of the format displayed below. The first entry on 
the first row is the number of markers to be analysed. Underneath this is a 
table in which the first two columns contain marker names, the third column 
contains the pairwise recombination fractions between the markers and the 
fourth column the associated LOD score.  Note that marker names in the first 
column vary more slowly than in the second column. Missing recombination pairs 
are acceptable. Recombination fractions greater than 0.499999 are set to that 
value.

\tabular{llll}{
\cr
\code{nmarkers} \tab \tab \tab \cr
\code{marker_1} \tab \code{marker_2} \tab \code{recombination fraction} \tab \code{LOD}\cr
\code{1} \tab \code{2} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
}
}
\examples{
smap<-calc.maps.sphere(system.file("extdata", "lgI.txt", package="MDSMap"),
weightfn='lod',mapfn='kosambi')
plot(smap)
}
\references{
\cite{de Leeuw J, Mair P (2009) Multidimensional scaling using majorization: SMACOF 
in R. J Stat Softw 31: 1-30} \url{https://www.jstatsoft.org/v31/i03/}
}
\seealso{
\code{\link{calc.maps.pc}}, \code{\link{calc.pair.rf.lod}}, \code{\link[smacof]{smacofSym}}, \code{\link[smacof]{smacofSphere}}, \code{\link{map.to.interval}}, \code{\link{dmap}}, \code{\link{calc.nnfit}}
}
