% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{calc.nnfit}
\alias{calc.nnfit}
\title{Calculate the nearest neighbour fit.}
\usage{
calc.nnfit(distmap, lodmap, estmap)
}
\arguments{
\item{distmap}{Symmetric matrix of pairwise inter-marker distances with 
columns and rows corresponding to the estimated map order.}

\item{lodmap}{Symmetric matrix of pairwise lod scores with columns and
rows corresponding to the estimated map order.}

\item{estmap}{Vector of estimated marker positions.}
}
\value{
A list with the elements:
\item{fit}{Sum of the nearest neighbour fits over all markers.}
\item{pointfits}{Vector of nearest neighbour fits for each marker.}
\item{meanfit}{Mean of the nearest neighbour fits over all markers.}
}
\description{
Calculates the total, mean and individual differences between the observed and 
estimated distances from all loci and their nearest neighbours with non-zero 
LOD scores.
}
\details{
The nearest neighbour fit for a marker is the sum of the difference between
the observed and estimated distances between the marker and its nearest
informative neighbour. A neighbour is informative if the LOD score for the 
inter-marker distance is greater than zero. This function calculates the nearest 
neighbour fit for each marker and returns the fit for each point and the sum 
of all the fits.
}
\seealso{
\code{\link{calc.nnfit.loci}}
}
