// Generated by rstantools.  Do not edit by hand.

/*
    MIRES is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    MIRES is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MIRES.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_redifhm_all_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_redifhm_all");
    reader.add_event(1, 1, "include", "/functions/common.stan");
    reader.add_event(1, 0, "start", "/functions/common.stan");
    reader.add_event(40, 39, "end", "/functions/common.stan");
    reader.add_event(40, 2, "restart", "model_redifhm_all");
    reader.add_event(40, 2, "include", "/functions/ud.stan");
    reader.add_event(40, 0, "start", "/functions/ud.stan");
    reader.add_event(102, 62, "end", "/functions/ud.stan");
    reader.add_event(102, 3, "restart", "model_redifhm_all");
    reader.add_event(102, 3, "include", "/functions/marg.stan");
    reader.add_event(102, 0, "start", "/functions/marg.stan");
    reader.add_event(196, 94, "end", "/functions/marg.stan");
    reader.add_event(196, 4, "restart", "model_redifhm_all");
    reader.add_event(196, 4, "include", "/functions/sum_to_zero.stan");
    reader.add_event(196, 0, "start", "/functions/sum_to_zero.stan");
    reader.add_event(220, 24, "end", "/functions/sum_to_zero.stan");
    reader.add_event(220, 5, "restart", "model_redifhm_all");
    reader.add_event(398, 181, "end", "model_redifhm_all");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
z_to_random(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sds,
                const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 11;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 12;
        int num(0);
        (void) num;  // dummy to suppress unused var warning
        stan::math::fill(num, std::numeric_limits<int>::min());
        stan::math::assign(num,cols(z));
        current_statement_begin__ = 13;
        validate_non_negative_index("re", "K", K);
        validate_non_negative_index("re", "num", num);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> re(K, num);
        stan::math::initialize(re, DUMMY_VAR__);
        stan::math::fill(re, DUMMY_VAR__);
        stan::math::assign(re,multiply(z, transpose(diag_pre_multiply(sds, L))));
        current_statement_begin__ = 15;
        return stan::math::promote_scalar<fun_return_scalar_t__>(re);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct z_to_random_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& sds,
                const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) const {
        return z_to_random(z, sds, L, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic>
compute_lambda_lowerbounds(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(lambda_random));
        current_statement_begin__ = 28;
        validate_non_negative_index("lambda_lowerbound", "J", J);
        Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_lowerbound(J);
        stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
        stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
        current_statement_begin__ = 30;
        for (int j = 1; j <= J; ++j) {
            current_statement_begin__ = 31;
            stan::model::assign(lambda_lowerbound, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        -(min(stan::model::rvalue(lambda_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), "lambda_random"))), 
                        "assigning variable lambda_lowerbound");
        }
        current_statement_begin__ = 34;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lambda_lowerbound);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct compute_lambda_lowerbounds_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random, std::ostream* pstream__) const {
        return compute_lambda_lowerbounds(lambda_random, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
L_to_cor(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 39;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply_lower_tri_self_transpose(L));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct L_to_cor_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& L, std::ostream* pstream__) const {
        return L_to_cor(L, pstream__);
    }
};
std::vector<int>
gen_item_indices(const int& J, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 48;
        validate_non_negative_index("hm_item_index", "(3 * J)", (3 * J));
        std::vector<int  > hm_item_index((3 * J), int(0));
        stan::math::fill(hm_item_index, std::numeric_limits<int>::min());
        current_statement_begin__ = 50;
        int base(0);
        (void) base;  // dummy to suppress unused var warning
        stan::math::fill(base, std::numeric_limits<int>::min());
        stan::math::assign(base,0);
        current_statement_begin__ = 51;
        for (int j = 1; j <= (3 * J); ++j) {
            current_statement_begin__ = 52;
            stan::model::assign(hm_item_index, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        (j - base), 
                        "assigning variable hm_item_index");
            current_statement_begin__ = 53;
            if (as_bool(logical_eq((j - base), J))) {
                current_statement_begin__ = 54;
                stan::math::assign(base, (base + J));
            }
        }
        current_statement_begin__ = 58;
        return stan::math::promote_scalar<fun_return_scalar_t__>(hm_item_index);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_item_indices_functor__ {
            std::vector<int>
    operator()(const int& J, std::ostream* pstream__) const {
        return gen_item_indices(J, pstream__);
    }
};
std::vector<int>
gen_param_indices(const int& J, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 69;
        validate_non_negative_index("hm_param_index", "(3 * J)", (3 * J));
        std::vector<int  > hm_param_index((3 * J), int(0));
        stan::math::fill(hm_param_index, std::numeric_limits<int>::min());
        current_statement_begin__ = 71;
        int base(0);
        (void) base;  // dummy to suppress unused var warning
        stan::math::fill(base, std::numeric_limits<int>::min());
        stan::math::assign(base,1);
        current_statement_begin__ = 72;
        for (int j = 1; j <= (3 * J); ++j) {
            current_statement_begin__ = 73;
            stan::model::assign(hm_param_index, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        base, 
                        "assigning variable hm_param_index");
            current_statement_begin__ = 74;
            if (as_bool(logical_eq(modulus(j, J), 0))) {
                current_statement_begin__ = 75;
                stan::math::assign(base, (base + 1));
            }
        }
        current_statement_begin__ = 79;
        return stan::math::promote_scalar<fun_return_scalar_t__>(hm_param_index);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_param_indices_functor__ {
            std::vector<int>
    operator()(const int& J, std::ostream* pstream__) const {
        return gen_param_indices(J, pstream__);
    }
};
std::vector<std::vector<int> >
gen_lamResNu_indices(const int& J, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 93;
        validate_non_negative_index("lamResNu_indices", "3", 3);
        validate_non_negative_index("lamResNu_indices", "J", J);
        std::vector<std::vector<int  >  > lamResNu_indices(3, std::vector<int>(J, int(0)));
        stan::math::fill(lamResNu_indices, std::numeric_limits<int>::min());
        current_statement_begin__ = 95;
        for (int p = 1; p <= 3; ++p) {
            current_statement_begin__ = 96;
            for (int j = 1; j <= J; ++j) {
                current_statement_begin__ = 97;
                stan::model::assign(lamResNu_indices, 
                            stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            (j + (J * (p - 1))), 
                            "assigning variable lamResNu_indices");
            }
        }
        current_statement_begin__ = 101;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lamResNu_indices);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gen_lamResNu_indices_functor__ {
            std::vector<std::vector<int> >
    operator()(const int& J, std::ostream* pstream__) const {
        return gen_lamResNu_indices(J, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic> >
marg_cov_uni(const Eigen::Matrix<T0__, 1, Eigen::Dynamic>& lambda,
                 const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& resid_log,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random,
                 const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& resid_random,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta_sd, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 119;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(lambda));
        current_statement_begin__ = 120;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(lambda_random));
        current_statement_begin__ = 121;
        validate_non_negative_index("cov_out", "J", J);
        validate_non_negative_index("cov_out", "J", J);
        validate_non_negative_index("cov_out", "K", K);
        std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>  > cov_out(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(J, J));
        stan::math::initialize(cov_out, DUMMY_VAR__);
        stan::math::fill(cov_out, DUMMY_VAR__);
        current_statement_begin__ = 122;
        validate_non_negative_index("lambda_k", "K", K);
        validate_non_negative_index("lambda_k", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda_k(K, J);
        stan::math::initialize(lambda_k, DUMMY_VAR__);
        stan::math::fill(lambda_k, DUMMY_VAR__);
        stan::math::assign(lambda_k,elt_multiply(add(rep_matrix(lambda, K), lambda_random), rep_matrix(eta_sd, J)));
        current_statement_begin__ = 123;
        validate_non_negative_index("resid_k", "K", K);
        validate_non_negative_index("resid_k", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> resid_k(K, J);
        stan::math::initialize(resid_k, DUMMY_VAR__);
        stan::math::fill(resid_k, DUMMY_VAR__);
        stan::math::assign(resid_k,stan::math::exp(multiply(2, add(rep_matrix(resid_log, K), resid_random))));
        current_statement_begin__ = 124;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 133;
            stan::model::assign(cov_out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        add(crossprod(to_matrix(stan::model::rvalue(lambda_k, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "lambda_k"))), diag_matrix(transpose(stan::model::rvalue(resid_k, stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "resid_k")))), 
                        "assigning variable cov_out");
        }
        current_statement_begin__ = 135;
        return stan::math::promote_scalar<fun_return_scalar_t__>(cov_out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct marg_cov_uni_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic> >
    operator()(const Eigen::Matrix<T0__, 1, Eigen::Dynamic>& lambda,
                 const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& resid_log,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random,
                 const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& resid_random,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta_sd, std::ostream* pstream__) const {
        return marg_cov_uni(lambda, resid_log, lambda_random, resid_random, eta_sd, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
marg_expect_uni(const Eigen::Matrix<T0__, 1, Eigen::Dynamic>& lambda,
                    const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& nu,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& nu_random,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta_mean, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 145;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(lambda));
        current_statement_begin__ = 146;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(lambda_random));
        current_statement_begin__ = 147;
        validate_non_negative_index("exp_out", "K", K);
        validate_non_negative_index("exp_out", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> exp_out(K, J);
        stan::math::initialize(exp_out, DUMMY_VAR__);
        stan::math::fill(exp_out, DUMMY_VAR__);
        current_statement_begin__ = 148;
        stan::math::assign(exp_out, add(add(rep_matrix(nu, K), nu_random), elt_multiply(rep_matrix(eta_mean, J), add(rep_matrix(lambda, K), lambda_random))));
        current_statement_begin__ = 152;
        return stan::math::promote_scalar<fun_return_scalar_t__>(exp_out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct marg_expect_uni_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, 1, Eigen::Dynamic>& lambda,
                    const Eigen::Matrix<T1__, 1, Eigen::Dynamic>& nu,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& lambda_random,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& nu_random,
                    const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta_mean, std::ostream* pstream__) const {
        return marg_expect_uni(lambda, nu, lambda_random, nu_random, eta_mean, pstream__);
    }
};
std::vector<std::vector<int> >
sort_data_by_group_indices(const std::vector<int>& group, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 156;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,max(group));
        current_statement_begin__ = 157;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        stan::math::assign(N,num_elements(group));
        current_statement_begin__ = 158;
        validate_non_negative_index("group_sorted", "N", N);
        std::vector<int  > group_sorted(N, int(0));
        stan::math::fill(group_sorted, std::numeric_limits<int>::min());
        stan::math::assign(group_sorted,sort_asc(group));
        current_statement_begin__ = 159;
        validate_non_negative_index("out", "K", K);
        validate_non_negative_index("out", "2", 2);
        std::vector<std::vector<int  >  > out(K, std::vector<int>(2, int(0)));
        stan::math::fill(out, std::numeric_limits<int>::min());
        current_statement_begin__ = 160;
        validate_non_negative_index("n_k", "K", K);
        std::vector<int  > n_k(K, int(0));
        stan::math::fill(n_k, std::numeric_limits<int>::min());
        stan::math::assign(n_k,rep_array(0, K));
        current_statement_begin__ = 161;
        int index(0);
        (void) index;  // dummy to suppress unused var warning
        stan::math::fill(index, std::numeric_limits<int>::min());
        stan::math::assign(index,1);
        current_statement_begin__ = 162;
        for (int n = 1; n <= N; ++n) {
            current_statement_begin__ = 163;
            stan::model::assign(n_k, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(group, n, "group", 1)), stan::model::nil_index_list()), 
                        (stan::model::rvalue(n_k, stan::model::cons_list(stan::model::index_uni(get_base1(group, n, "group", 1)), stan::model::nil_index_list()), "n_k") + 1), 
                        "assigning variable n_k");
        }
        current_statement_begin__ = 165;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 166;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        index, 
                        "assigning variable out");
            current_statement_begin__ = 167;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        ((index + get_base1(n_k, k, "n_k", 1)) - 1), 
                        "assigning variable out");
            current_statement_begin__ = 168;
            stan::math::assign(index, (index + get_base1(n_k, k, "n_k", 1)));
        }
        current_statement_begin__ = 170;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct sort_data_by_group_indices_functor__ {
            std::vector<std::vector<int> >
    operator()(const std::vector<int>& group, std::ostream* pstream__) const {
        return sort_data_by_group_indices(group, pstream__);
    }
};
template <typename T0__>
std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic> >
sort_data_by_group(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
                       const std::vector<int>& group, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 174;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,max(group));
        current_statement_begin__ = 175;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        stan::math::assign(N,rows(x));
        current_statement_begin__ = 176;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(x));
        current_statement_begin__ = 177;
        validate_non_negative_index("out", "J", J);
        validate_non_negative_index("out", "N", N);
        std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>  > out(N, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(J));
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 179;
        validate_non_negative_index("group_ordered", "N", N);
        std::vector<int  > group_ordered(N, int(0));
        stan::math::fill(group_ordered, std::numeric_limits<int>::min());
        stan::math::assign(group_ordered,sort_indices_asc(group));
        current_statement_begin__ = 191;
        for (int n = 1; n <= N; ++n) {
            current_statement_begin__ = 192;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        get_base1(x, get_base1(group_ordered, n, "group_ordered", 1), "x", 1), 
                        "assigning variable out");
        }
        current_statement_begin__ = 194;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct sort_data_by_group_functor__ {
    template <typename T0__>
        std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, 1, Eigen::Dynamic> >
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& x,
                       const std::vector<int>& group, std::ostream* pstream__) const {
        return sort_data_by_group(x, group, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
eta_means_stz(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta_mean_s, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 203;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,(num_elements(eta_mean_s) + 1));
        current_statement_begin__ = 204;
        validate_non_negative_index("eta_mean", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_mean(K);
        stan::math::initialize(eta_mean, DUMMY_VAR__);
        stan::math::fill(eta_mean, DUMMY_VAR__);
        current_statement_begin__ = 205;
        stan::model::assign(eta_mean, 
                    stan::model::cons_list(stan::model::index_min_max(2, K), stan::model::nil_index_list()), 
                    eta_mean_s, 
                    "assigning variable eta_mean");
        current_statement_begin__ = 206;
        stan::model::assign(eta_mean, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    -(sum(eta_mean_s)), 
                    "assigning variable eta_mean");
        current_statement_begin__ = 208;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta_mean);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct eta_means_stz_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta_mean_s, std::ostream* pstream__) const {
        return eta_means_stz(eta_mean_s, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
eta_sds_pto(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta_sd_s, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 213;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,(num_elements(eta_sd_s) + 1));
        current_statement_begin__ = 214;
        validate_non_negative_index("eta_sd", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_sd(K);
        stan::math::initialize(eta_sd, DUMMY_VAR__);
        stan::math::fill(eta_sd, DUMMY_VAR__);
        current_statement_begin__ = 215;
        stan::model::assign(eta_sd, 
                    stan::model::cons_list(stan::model::index_min_max(2, K), stan::model::nil_index_list()), 
                    eta_sd_s, 
                    "assigning variable eta_sd");
        current_statement_begin__ = 216;
        stan::model::assign(eta_sd, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    stan::math::exp(-(sum(stan::math::log(eta_sd_s)))), 
                    "assigning variable eta_sd");
        current_statement_begin__ = 218;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta_sd);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct eta_sds_pto_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta_sd_s, std::ostream* pstream__) const {
        return eta_sds_pto(eta_sd_s, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_redifhm_all
  : public stan::model::model_base_crtp<model_redifhm_all> {
private:
        int N;
        int J;
        int K;
        std::vector<int> group;
        matrix_d x;
        int prior_only;
        int eta_cor_nonmi;
        int use_hmre;
        double hmre_mu;
        double hmre_scale;
        int marginalize;
        int sum_coding;
        int total;
        std::vector<int> hm_item_index;
        std::vector<int> hm_param_index;
        std::vector<std::vector<int> > lamResNu_indices;
        int save_scores;
        int hier_coding;
        vector_d x_vector;
        std::vector<row_vector_d> x_sorted;
        std::vector<std::vector<int> > x_sorted_indices;
public:
    model_redifhm_all(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_redifhm_all(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_redifhm_all_namespace::model_redifhm_all";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 225;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 226;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 227;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 229;
            validate_non_negative_index("group", "N", N);
            context__.validate_dims("data initialization", "group", "int", context__.to_vec(N));
            group = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("group");
            pos__ = 0;
            size_t group_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < group_k_0_max__; ++k_0__) {
                group[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 231;
            validate_non_negative_index("x", "N", N);
            validate_non_negative_index("x", "J", J);
            context__.validate_dims("data initialization", "x", "matrix_d", context__.to_vec(N,J));
            x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, J);
            vals_r__ = context__.vals_r("x");
            pos__ = 0;
            size_t x_j_2_max__ = J;
            size_t x_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < x_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_j_1_max__; ++j_1__) {
                    x(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 234;
            context__.validate_dims("data initialization", "prior_only", "int", context__.to_vec());
            prior_only = int(0);
            vals_i__ = context__.vals_i("prior_only");
            pos__ = 0;
            prior_only = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_only", prior_only, 0);
            check_less_or_equal(function__, "prior_only", prior_only, 1);
            current_statement_begin__ = 236;
            context__.validate_dims("data initialization", "eta_cor_nonmi", "int", context__.to_vec());
            eta_cor_nonmi = int(0);
            vals_i__ = context__.vals_i("eta_cor_nonmi");
            pos__ = 0;
            eta_cor_nonmi = vals_i__[pos__++];
            current_statement_begin__ = 238;
            context__.validate_dims("data initialization", "use_hmre", "int", context__.to_vec());
            use_hmre = int(0);
            vals_i__ = context__.vals_i("use_hmre");
            pos__ = 0;
            use_hmre = vals_i__[pos__++];
            check_greater_or_equal(function__, "use_hmre", use_hmre, 0);
            check_less_or_equal(function__, "use_hmre", use_hmre, 1);
            current_statement_begin__ = 239;
            context__.validate_dims("data initialization", "hmre_mu", "double", context__.to_vec());
            hmre_mu = double(0);
            vals_r__ = context__.vals_r("hmre_mu");
            pos__ = 0;
            hmre_mu = vals_r__[pos__++];
            current_statement_begin__ = 240;
            context__.validate_dims("data initialization", "hmre_scale", "double", context__.to_vec());
            hmre_scale = double(0);
            vals_r__ = context__.vals_r("hmre_scale");
            pos__ = 0;
            hmre_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "hmre_scale", hmre_scale, 0);
            current_statement_begin__ = 242;
            context__.validate_dims("data initialization", "marginalize", "int", context__.to_vec());
            marginalize = int(0);
            vals_i__ = context__.vals_i("marginalize");
            pos__ = 0;
            marginalize = vals_i__[pos__++];
            check_greater_or_equal(function__, "marginalize", marginalize, 0);
            check_less_or_equal(function__, "marginalize", marginalize, 1);
            current_statement_begin__ = 244;
            context__.validate_dims("data initialization", "sum_coding", "int", context__.to_vec());
            sum_coding = int(0);
            vals_i__ = context__.vals_i("sum_coding");
            pos__ = 0;
            sum_coding = vals_i__[pos__++];
            check_greater_or_equal(function__, "sum_coding", sum_coding, 0);
            check_less_or_equal(function__, "sum_coding", sum_coding, 1);
            // initialize transformed data variables
            current_statement_begin__ = 248;
            total = int(0);
            stan::math::fill(total, std::numeric_limits<int>::min());
            stan::math::assign(total,(3 * J));
            current_statement_begin__ = 249;
            validate_non_negative_index("hm_item_index", "total", total);
            hm_item_index = std::vector<int>(total, int(0));
            stan::math::fill(hm_item_index, std::numeric_limits<int>::min());
            stan::math::assign(hm_item_index,gen_item_indices(J, pstream__));
            current_statement_begin__ = 250;
            validate_non_negative_index("hm_param_index", "total", total);
            hm_param_index = std::vector<int>(total, int(0));
            stan::math::fill(hm_param_index, std::numeric_limits<int>::min());
            stan::math::assign(hm_param_index,gen_param_indices(J, pstream__));
            current_statement_begin__ = 251;
            validate_non_negative_index("lamResNu_indices", "3", 3);
            validate_non_negative_index("lamResNu_indices", "J", J);
            lamResNu_indices = std::vector<std::vector<int> >(3, std::vector<int>(J, int(0)));
            stan::math::fill(lamResNu_indices, std::numeric_limits<int>::min());
            stan::math::assign(lamResNu_indices,gen_lamResNu_indices(J, pstream__));
            current_statement_begin__ = 252;
            save_scores = int(0);
            stan::math::fill(save_scores, std::numeric_limits<int>::min());
            stan::math::assign(save_scores,(1 - marginalize));
            current_statement_begin__ = 253;
            hier_coding = int(0);
            stan::math::fill(hier_coding, std::numeric_limits<int>::min());
            stan::math::assign(hier_coding,(1 - sum_coding));
            current_statement_begin__ = 254;
            validate_non_negative_index("x_vector", "(N * J)", (N * J));
            x_vector = Eigen::Matrix<double, Eigen::Dynamic, 1>((N * J));
            stan::math::fill(x_vector, DUMMY_VAR__);
            current_statement_begin__ = 255;
            validate_non_negative_index("x_sorted", "J", J);
            validate_non_negative_index("x_sorted", "N", N);
            x_sorted = std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(N, Eigen::Matrix<double, 1, Eigen::Dynamic>(J));
            stan::math::fill(x_sorted, DUMMY_VAR__);
            current_statement_begin__ = 256;
            validate_non_negative_index("x_sorted_indices", "K", K);
            validate_non_negative_index("x_sorted_indices", "2", 2);
            x_sorted_indices = std::vector<std::vector<int> >(K, std::vector<int>(2, int(0)));
            stan::math::fill(x_sorted_indices, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 259;
            if (as_bool(save_scores)) {
                current_statement_begin__ = 260;
                stan::math::assign(x_vector, to_vector(x));
            } else {
                current_statement_begin__ = 262;
                stan::math::assign(x_sorted, sort_data_by_group(x, group, pstream__));
                current_statement_begin__ = 263;
                stan::math::assign(x_sorted_indices, sort_data_by_group_indices(group, pstream__));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 270;
            validate_non_negative_index("lambda_log", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 271;
            validate_non_negative_index("nu", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 272;
            validate_non_negative_index("resid_log", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 275;
            validate_non_negative_index("random_z", "K", K);
            validate_non_negative_index("random_z", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            num_params_r__ += (K * (total + (2 * hier_coding)));
            current_statement_begin__ = 276;
            validate_non_negative_index("random_L", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            validate_non_negative_index("random_L", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            num_params_r__ += (((total + (2 * hier_coding)) * ((total + (2 * hier_coding)) - 1)) / 2);
            current_statement_begin__ = 277;
            validate_non_negative_index("random_sigma", "total", total);
            num_params_r__ += total;
            current_statement_begin__ = 281;
            validate_non_negative_index("eta_z", "(N * save_scores)", (N * save_scores));
            num_params_r__ += (N * save_scores);
            current_statement_begin__ = 283;
            validate_non_negative_index("eta_random_sigma", "(2 * hier_coding)", (2 * hier_coding));
            num_params_r__ += (2 * hier_coding);
            current_statement_begin__ = 286;
            validate_non_negative_index("eta_mean_s", "((K - 1) * sum_coding)", ((K - 1) * sum_coding));
            num_params_r__ += ((K - 1) * sum_coding);
            current_statement_begin__ = 287;
            validate_non_negative_index("eta_sd_s", "((K - 1) * sum_coding)", ((K - 1) * sum_coding));
            num_params_r__ += ((K - 1) * sum_coding);
            current_statement_begin__ = 290;
            num_params_r__ += 1;
            current_statement_begin__ = 291;
            validate_non_negative_index("hm_param", "(3 * use_hmre)", (3 * use_hmre));
            num_params_r__ += (3 * use_hmre);
            current_statement_begin__ = 292;
            validate_non_negative_index("hm_item", "(J * use_hmre)", (J * use_hmre));
            num_params_r__ += (J * use_hmre);
            current_statement_begin__ = 293;
            validate_non_negative_index("hm_lambda", "total", total);
            num_params_r__ += total;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_redifhm_all() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 270;
        if (!(context__.contains_r("lambda_log")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_log missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_log");
        pos__ = 0U;
        validate_non_negative_index("lambda_log", "J", J);
        context__.validate_dims("parameter initialization", "lambda_log", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_log(J);
        size_t lambda_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < lambda_log_j_1_max__; ++j_1__) {
            lambda_log(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(lambda_log);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_log: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 271;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "J", J);
        context__.validate_dims("parameter initialization", "nu", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            nu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 272;
        if (!(context__.contains_r("resid_log")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable resid_log missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("resid_log");
        pos__ = 0U;
        validate_non_negative_index("resid_log", "J", J);
        context__.validate_dims("parameter initialization", "resid_log", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> resid_log(J);
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            resid_log(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(resid_log);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable resid_log: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 275;
        if (!(context__.contains_r("random_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_z");
        pos__ = 0U;
        validate_non_negative_index("random_z", "K", K);
        validate_non_negative_index("random_z", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
        context__.validate_dims("parameter initialization", "random_z", "matrix_d", context__.to_vec(K,(total + (2 * hier_coding))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_z(K, (total + (2 * hier_coding)));
        size_t random_z_j_2_max__ = (total + (2 * hier_coding));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                random_z(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(random_z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 276;
        if (!(context__.contains_r("random_L")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_L missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_L");
        pos__ = 0U;
        validate_non_negative_index("random_L", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
        validate_non_negative_index("random_L", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
        context__.validate_dims("parameter initialization", "random_L", "matrix_d", context__.to_vec((total + (2 * hier_coding)),(total + (2 * hier_coding))));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_L((total + (2 * hier_coding)), (total + (2 * hier_coding)));
        size_t random_L_j_2_max__ = (total + (2 * hier_coding));
        size_t random_L_j_1_max__ = (total + (2 * hier_coding));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                random_L(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(random_L);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_L: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 277;
        if (!(context__.contains_r("random_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable random_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("random_sigma");
        pos__ = 0U;
        validate_non_negative_index("random_sigma", "total", total);
        context__.validate_dims("parameter initialization", "random_sigma", "vector_d", context__.to_vec(total));
        Eigen::Matrix<double, Eigen::Dynamic, 1> random_sigma(total);
        size_t random_sigma_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            random_sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, random_sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable random_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 281;
        if (!(context__.contains_r("eta_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_z");
        pos__ = 0U;
        validate_non_negative_index("eta_z", "(N * save_scores)", (N * save_scores));
        context__.validate_dims("parameter initialization", "eta_z", "vector_d", context__.to_vec((N * save_scores)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_z((N * save_scores));
        size_t eta_z_j_1_max__ = (N * save_scores);
        for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
            eta_z(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta_z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 283;
        if (!(context__.contains_r("eta_random_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_random_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_random_sigma");
        pos__ = 0U;
        validate_non_negative_index("eta_random_sigma", "(2 * hier_coding)", (2 * hier_coding));
        context__.validate_dims("parameter initialization", "eta_random_sigma", "vector_d", context__.to_vec((2 * hier_coding)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_random_sigma((2 * hier_coding));
        size_t eta_random_sigma_j_1_max__ = (2 * hier_coding);
        for (size_t j_1__ = 0; j_1__ < eta_random_sigma_j_1_max__; ++j_1__) {
            eta_random_sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, eta_random_sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_random_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 286;
        if (!(context__.contains_r("eta_mean_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_mean_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_mean_s");
        pos__ = 0U;
        validate_non_negative_index("eta_mean_s", "((K - 1) * sum_coding)", ((K - 1) * sum_coding));
        context__.validate_dims("parameter initialization", "eta_mean_s", "vector_d", context__.to_vec(((K - 1) * sum_coding)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_mean_s(((K - 1) * sum_coding));
        size_t eta_mean_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_mean_s_j_1_max__; ++j_1__) {
            eta_mean_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta_mean_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_mean_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 287;
        if (!(context__.contains_r("eta_sd_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta_sd_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta_sd_s");
        pos__ = 0U;
        validate_non_negative_index("eta_sd_s", "((K - 1) * sum_coding)", ((K - 1) * sum_coding));
        context__.validate_dims("parameter initialization", "eta_sd_s", "vector_d", context__.to_vec(((K - 1) * sum_coding)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_sd_s(((K - 1) * sum_coding));
        size_t eta_sd_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_sd_s_j_1_max__; ++j_1__) {
            eta_sd_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, eta_sd_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta_sd_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 290;
        if (!(context__.contains_r("hm_tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hm_tau", "double", context__.to_vec());
        double hm_tau(0);
        hm_tau = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(hm_tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 291;
        if (!(context__.contains_r("hm_param")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_param missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_param");
        pos__ = 0U;
        validate_non_negative_index("hm_param", "(3 * use_hmre)", (3 * use_hmre));
        context__.validate_dims("parameter initialization", "hm_param", "vector_d", context__.to_vec((3 * use_hmre)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_param((3 * use_hmre));
        size_t hm_param_j_1_max__ = (3 * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            hm_param(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_param);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_param: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 292;
        if (!(context__.contains_r("hm_item")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_item missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_item");
        pos__ = 0U;
        validate_non_negative_index("hm_item", "(J * use_hmre)", (J * use_hmre));
        context__.validate_dims("parameter initialization", "hm_item", "vector_d", context__.to_vec((J * use_hmre)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_item((J * use_hmre));
        size_t hm_item_j_1_max__ = (J * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            hm_item(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_item);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_item: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 293;
        if (!(context__.contains_r("hm_lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hm_lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hm_lambda");
        pos__ = 0U;
        validate_non_negative_index("hm_lambda", "total", total);
        context__.validate_dims("parameter initialization", "hm_lambda", "vector_d", context__.to_vec(total));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_lambda(total);
        size_t hm_lambda_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            hm_lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(hm_lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hm_lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 270;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_log;
            (void) lambda_log;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_log = in__.row_vector_constrain(J, lp__);
            else
                lambda_log = in__.row_vector_constrain(J);
            current_statement_begin__ = 271;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.row_vector_constrain(J, lp__);
            else
                nu = in__.row_vector_constrain(J);
            current_statement_begin__ = 272;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> resid_log;
            (void) resid_log;  // dummy to suppress unused var warning
            if (jacobian__)
                resid_log = in__.row_vector_constrain(J, lp__);
            else
                resid_log = in__.row_vector_constrain(J);
            current_statement_begin__ = 275;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random_z;
            (void) random_z;  // dummy to suppress unused var warning
            if (jacobian__)
                random_z = in__.matrix_constrain(K, (total + (2 * hier_coding)), lp__);
            else
                random_z = in__.matrix_constrain(K, (total + (2 * hier_coding)));
            current_statement_begin__ = 276;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random_L;
            (void) random_L;  // dummy to suppress unused var warning
            if (jacobian__)
                random_L = in__.cholesky_factor_corr_constrain((total + (2 * hier_coding)), lp__);
            else
                random_L = in__.cholesky_factor_corr_constrain((total + (2 * hier_coding)));
            current_statement_begin__ = 277;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> random_sigma;
            (void) random_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                random_sigma = in__.vector_lb_constrain(0, total, lp__);
            else
                random_sigma = in__.vector_lb_constrain(0, total);
            current_statement_begin__ = 281;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_z;
            (void) eta_z;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_z = in__.vector_constrain((N * save_scores), lp__);
            else
                eta_z = in__.vector_constrain((N * save_scores));
            current_statement_begin__ = 283;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_random_sigma;
            (void) eta_random_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_random_sigma = in__.vector_lb_constrain(0, (2 * hier_coding), lp__);
            else
                eta_random_sigma = in__.vector_lb_constrain(0, (2 * hier_coding));
            current_statement_begin__ = 286;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_mean_s;
            (void) eta_mean_s;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_mean_s = in__.vector_constrain(((K - 1) * sum_coding), lp__);
            else
                eta_mean_s = in__.vector_constrain(((K - 1) * sum_coding));
            current_statement_begin__ = 287;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_sd_s;
            (void) eta_sd_s;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_sd_s = in__.vector_lb_constrain(0, ((K - 1) * sum_coding), lp__);
            else
                eta_sd_s = in__.vector_lb_constrain(0, ((K - 1) * sum_coding));
            current_statement_begin__ = 290;
            local_scalar_t__ hm_tau;
            (void) hm_tau;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_tau = in__.scalar_constrain(lp__);
            else
                hm_tau = in__.scalar_constrain();
            current_statement_begin__ = 291;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_param;
            (void) hm_param;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_param = in__.vector_constrain((3 * use_hmre), lp__);
            else
                hm_param = in__.vector_constrain((3 * use_hmre));
            current_statement_begin__ = 292;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_item;
            (void) hm_item;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_item = in__.vector_constrain((J * use_hmre), lp__);
            else
                hm_item = in__.vector_constrain((J * use_hmre));
            current_statement_begin__ = 293;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_lambda;
            (void) hm_lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                hm_lambda = in__.vector_constrain(total, lp__);
            else
                hm_lambda = in__.vector_constrain(total);
            // transformed parameters
            current_statement_begin__ = 297;
            validate_non_negative_index("random_sigma_all", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> random_sigma_all((total + (2 * hier_coding)));
            stan::math::initialize(random_sigma_all, DUMMY_VAR__);
            stan::math::fill(random_sigma_all, DUMMY_VAR__);
            stan::math::assign(random_sigma_all,append_row(random_sigma, eta_random_sigma));
            current_statement_begin__ = 298;
            validate_non_negative_index("random", "K", K);
            validate_non_negative_index("random", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> random(K, (total + (2 * hier_coding)));
            stan::math::initialize(random, DUMMY_VAR__);
            stan::math::fill(random, DUMMY_VAR__);
            stan::math::assign(random,z_to_random(random_z, random_sigma_all, random_L, pstream__));
            current_statement_begin__ = 299;
            validate_non_negative_index("lambda_random", "K", K);
            validate_non_negative_index("lambda_random", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> lambda_random(K, J);
            stan::math::initialize(lambda_random, DUMMY_VAR__);
            stan::math::fill(lambda_random, DUMMY_VAR__);
            stan::math::assign(lambda_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 1, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 300;
            validate_non_negative_index("resid_random", "K", K);
            validate_non_negative_index("resid_random", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> resid_random(K, J);
            stan::math::initialize(resid_random, DUMMY_VAR__);
            stan::math::fill(resid_random, DUMMY_VAR__);
            stan::math::assign(resid_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 2, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 301;
            validate_non_negative_index("nu_random", "K", K);
            validate_non_negative_index("nu_random", "J", J);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> nu_random(K, J);
            stan::math::initialize(nu_random, DUMMY_VAR__);
            stan::math::fill(nu_random, DUMMY_VAR__);
            stan::math::assign(nu_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 3, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 302;
            validate_non_negative_index("eta_mean", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_mean(K);
            stan::math::initialize(eta_mean, DUMMY_VAR__);
            stan::math::fill(eta_mean, DUMMY_VAR__);
            stan::math::assign(eta_mean,(sum_coding ? stan::math::promote_scalar<local_scalar_t__>(eta_means_stz(eta_mean_s, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((total + 1)), stan::model::nil_index_list())), "random")) ));
            current_statement_begin__ = 303;
            validate_non_negative_index("eta_sd", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_sd(K);
            stan::math::initialize(eta_sd, DUMMY_VAR__);
            stan::math::fill(eta_sd, DUMMY_VAR__);
            stan::math::assign(eta_sd,(sum_coding ? stan::math::promote_scalar<local_scalar_t__>(eta_sds_pto(eta_sd_s, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(stan::math::exp(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((total + 2)), stan::model::nil_index_list())), "random"))) ));
            current_statement_begin__ = 304;
            validate_non_negative_index("lambda_lowerbound", "J", J);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda_lowerbound(J);
            stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
            stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
            stan::math::assign(lambda_lowerbound,compute_lambda_lowerbounds(lambda_random, pstream__));
            current_statement_begin__ = 305;
            validate_non_negative_index("lambda", "J", J);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda, DUMMY_VAR__);
            stan::math::assign(lambda,add(stan::math::exp(lambda_log), lambda_lowerbound));
            current_statement_begin__ = 306;
            validate_non_negative_index("eta", "(N * save_scores)", (N * save_scores));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta((N * save_scores));
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 307;
            validate_non_negative_index("multi_normal_mu", "(K * marginalize)", (K * marginalize));
            validate_non_negative_index("multi_normal_mu", "(J * marginalize)", (J * marginalize));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> multi_normal_mu((K * marginalize), (J * marginalize));
            stan::math::initialize(multi_normal_mu, DUMMY_VAR__);
            stan::math::fill(multi_normal_mu, DUMMY_VAR__);
            current_statement_begin__ = 308;
            validate_non_negative_index("multi_normal_sigma", "(J * marginalize)", (J * marginalize));
            validate_non_negative_index("multi_normal_sigma", "(J * marginalize)", (J * marginalize));
            validate_non_negative_index("multi_normal_sigma", "(K * marginalize)", (K * marginalize));
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > multi_normal_sigma((K * marginalize), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>((J * marginalize), (J * marginalize)));
            stan::math::initialize(multi_normal_sigma, DUMMY_VAR__);
            stan::math::fill(multi_normal_sigma, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 310;
            if (as_bool(save_scores)) {
                current_statement_begin__ = 311;
                stan::math::assign(eta, add(stan::model::rvalue(eta_mean, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_mean"), elt_multiply(eta_z, stan::model::rvalue(eta_sd, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_sd"))));
            } else {
                current_statement_begin__ = 314;
                stan::math::assign(multi_normal_mu, marg_expect_uni(lambda, nu, lambda_random, nu_random, eta_mean, pstream__));
                current_statement_begin__ = 315;
                stan::math::assign(multi_normal_sigma, marg_cov_uni(lambda, resid_log, lambda_random, resid_random, eta_sd, pstream__));
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 297;
            size_t random_sigma_all_j_1_max__ = (total + (2 * hier_coding));
            for (size_t j_1__ = 0; j_1__ < random_sigma_all_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(random_sigma_all(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: random_sigma_all" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable random_sigma_all: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "random_sigma_all", random_sigma_all, 0);
            current_statement_begin__ = 298;
            size_t random_j_1_max__ = K;
            size_t random_j_2_max__ = (total + (2 * hier_coding));
            for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 299;
            size_t lambda_random_j_1_max__ = K;
            size_t lambda_random_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(lambda_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: lambda_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 300;
            size_t resid_random_j_1_max__ = K;
            size_t resid_random_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(resid_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: resid_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable resid_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 301;
            size_t nu_random_j_1_max__ = K;
            size_t nu_random_j_2_max__ = J;
            for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(nu_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: nu_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable nu_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 302;
            size_t eta_mean_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_mean(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_mean" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_mean: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 303;
            size_t eta_sd_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_sd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_sd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 304;
            size_t lambda_lowerbound_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda_lowerbound(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda_lowerbound" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_lowerbound: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 305;
            size_t lambda_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 306;
            size_t eta_j_1_max__ = (N * save_scores);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 307;
            size_t multi_normal_mu_j_1_max__ = (K * marginalize);
            size_t multi_normal_mu_j_2_max__ = (J * marginalize);
            for (size_t j_1__ = 0; j_1__ < multi_normal_mu_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < multi_normal_mu_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(multi_normal_mu(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: multi_normal_mu" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable multi_normal_mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 308;
            size_t multi_normal_sigma_k_0_max__ = (K * marginalize);
            size_t multi_normal_sigma_j_1_max__ = (J * marginalize);
            size_t multi_normal_sigma_j_2_max__ = (J * marginalize);
            for (size_t k_0__ = 0; k_0__ < multi_normal_sigma_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < multi_normal_sigma_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < multi_normal_sigma_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(multi_normal_sigma[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: multi_normal_sigma" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable multi_normal_sigma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 321;
            validate_non_negative_index("xhat", "(N * save_scores)", (N * save_scores));
            validate_non_negative_index("xhat", "(J * save_scores)", (J * save_scores));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> xhat((N * save_scores), (J * save_scores));
            stan::math::initialize(xhat, DUMMY_VAR__);
            stan::math::fill(xhat, DUMMY_VAR__);
            current_statement_begin__ = 322;
            validate_non_negative_index("s_loghat", "(N * save_scores)", (N * save_scores));
            validate_non_negative_index("s_loghat", "(J * save_scores)", (J * save_scores));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> s_loghat((N * save_scores), (J * save_scores));
            stan::math::initialize(s_loghat, DUMMY_VAR__);
            stan::math::fill(s_loghat, DUMMY_VAR__);
            current_statement_begin__ = 323;
            validate_non_negative_index("hm_hat", "total", total);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hm_hat(total);
            stan::math::initialize(hm_hat, DUMMY_VAR__);
            stan::math::fill(hm_hat, DUMMY_VAR__);
            current_statement_begin__ = 324;
            if (as_bool(save_scores)) {
                current_statement_begin__ = 325;
                stan::math::assign(xhat, add(rep_matrix(nu, N), multiply(eta, lambda)));
                current_statement_begin__ = 326;
                stan::math::assign(s_loghat, rep_matrix(resid_log, N));
                current_statement_begin__ = 327;
                stan::math::assign(xhat, add(xhat, add(stan::model::rvalue(nu_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "nu_random"), elt_multiply(rep_matrix(eta, J), stan::model::rvalue(lambda_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "lambda_random")))));
                current_statement_begin__ = 328;
                stan::math::assign(s_loghat, add(s_loghat, stan::model::rvalue(resid_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "resid_random")));
            }
            current_statement_begin__ = 331;
            if (as_bool(use_hmre)) {
                current_statement_begin__ = 332;
                stan::math::assign(hm_hat, stan::math::exp(add(add(add(hm_tau, stan::model::rvalue(hm_param, stan::model::cons_list(stan::model::index_multi(hm_param_index), stan::model::nil_index_list()), "hm_param")), stan::model::rvalue(hm_item, stan::model::cons_list(stan::model::index_multi(hm_item_index), stan::model::nil_index_list()), "hm_item")), hm_lambda)));
            } else {
                current_statement_begin__ = 335;
                stan::math::assign(hm_hat, stan::math::exp(hm_lambda));
            }
            current_statement_begin__ = 345;
            lp_accum__.add(((normal_log(lambda, 0, 1) - normal_ccdf_log(lambda_lowerbound, 0, 1)) + sum(lambda_log)));
            current_statement_begin__ = 347;
            lp_accum__.add(std_normal_log<propto__>(resid_log));
            current_statement_begin__ = 349;
            lp_accum__.add(std_normal_log<propto__>(nu));
            current_statement_begin__ = 352;
            lp_accum__.add(std_normal_log<propto__>(to_vector(random_z)));
            current_statement_begin__ = 353;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(random_L, 1));
            current_statement_begin__ = 356;
            if (as_bool(save_scores)) {
                current_statement_begin__ = 357;
                lp_accum__.add(std_normal_log<propto__>(eta_z));
            }
            current_statement_begin__ = 361;
            if (as_bool(sum_coding)) {
                current_statement_begin__ = 362;
                lp_accum__.add(std_normal_log<propto__>(eta_mean_s));
                current_statement_begin__ = 363;
                lp_accum__.add(std_normal_log<propto__>(eta_sd_s));
            } else {
                current_statement_begin__ = 365;
                lp_accum__.add(std_normal_log<propto__>(eta_random_sigma));
            }
            current_statement_begin__ = 369;
            lp_accum__.add(normal_log<propto__>(hm_tau, hmre_mu, hmre_scale));
            current_statement_begin__ = 370;
            if (as_bool(use_hmre)) {
                current_statement_begin__ = 371;
                lp_accum__.add(normal_log<propto__>(hm_param, hmre_mu, hmre_scale));
                current_statement_begin__ = 372;
                lp_accum__.add(normal_log<propto__>(hm_item, hmre_mu, hmre_scale));
                current_statement_begin__ = 373;
                lp_accum__.add(normal_log<propto__>(hm_lambda, hmre_mu, hmre_scale));
            } else {
                current_statement_begin__ = 375;
                lp_accum__.add(normal_log<propto__>(hm_lambda, (4 * hmre_mu), (2 * hmre_scale)));
            }
            current_statement_begin__ = 379;
            lp_accum__.add(normal_log<propto__>(random_sigma, 0, hm_hat));
            current_statement_begin__ = 382;
            if (as_bool(logical_negation(prior_only))) {
                current_statement_begin__ = 383;
                if (as_bool(save_scores)) {
                    current_statement_begin__ = 384;
                    lp_accum__.add(normal_log<propto__>(x_vector, to_vector(xhat), to_vector(stan::math::exp(s_loghat))));
                } else {
                    current_statement_begin__ = 386;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 387;
                        lp_accum__.add(multi_normal_log<propto__>(stan::model::rvalue(x_sorted, stan::model::cons_list(stan::model::index_min_max(get_base1(get_base1(x_sorted_indices, k, "x_sorted_indices", 1), 1, "x_sorted_indices", 2), get_base1(get_base1(x_sorted_indices, k, "x_sorted_indices", 1), 2, "x_sorted_indices", 2)), stan::model::nil_index_list()), "x_sorted"), get_base1(multi_normal_mu, k, "multi_normal_mu", 1), get_base1(multi_normal_sigma, k, "multi_normal_sigma", 1)));
                    }
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("lambda_log");
        names__.push_back("nu");
        names__.push_back("resid_log");
        names__.push_back("random_z");
        names__.push_back("random_L");
        names__.push_back("random_sigma");
        names__.push_back("eta_z");
        names__.push_back("eta_random_sigma");
        names__.push_back("eta_mean_s");
        names__.push_back("eta_sd_s");
        names__.push_back("hm_tau");
        names__.push_back("hm_param");
        names__.push_back("hm_item");
        names__.push_back("hm_lambda");
        names__.push_back("random_sigma_all");
        names__.push_back("random");
        names__.push_back("lambda_random");
        names__.push_back("resid_random");
        names__.push_back("nu_random");
        names__.push_back("eta_mean");
        names__.push_back("eta_sd");
        names__.push_back("lambda_lowerbound");
        names__.push_back("lambda");
        names__.push_back("eta");
        names__.push_back("multi_normal_mu");
        names__.push_back("multi_normal_sigma");
        names__.push_back("RE_cor");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((total + (2 * hier_coding)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((total + (2 * hier_coding)));
        dims__.push_back((total + (2 * hier_coding)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((N * save_scores));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((2 * hier_coding));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((K - 1) * sum_coding));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((K - 1) * sum_coding));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((3 * use_hmre));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * use_hmre));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((total + (2 * hier_coding)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((total + (2 * hier_coding)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((N * save_scores));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * marginalize));
        dims__.push_back((J * marginalize));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * marginalize));
        dims__.push_back((J * marginalize));
        dims__.push_back((J * marginalize));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(total);
        dims__.push_back(total);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_redifhm_all_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_log = in__.row_vector_constrain(J);
        size_t lambda_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < lambda_log_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_log(j_1__));
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu = in__.row_vector_constrain(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            vars__.push_back(nu(j_1__));
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> resid_log = in__.row_vector_constrain(J);
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            vars__.push_back(resid_log(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_z = in__.matrix_constrain(K, (total + (2 * hier_coding)));
        size_t random_z_j_2_max__ = (total + (2 * hier_coding));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                vars__.push_back(random_z(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random_L = in__.cholesky_factor_corr_constrain((total + (2 * hier_coding)));
        size_t random_L_j_2_max__ = (total + (2 * hier_coding));
        size_t random_L_j_1_max__ = (total + (2 * hier_coding));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                vars__.push_back(random_L(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> random_sigma = in__.vector_lb_constrain(0, total);
        size_t random_sigma_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            vars__.push_back(random_sigma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_z = in__.vector_constrain((N * save_scores));
        size_t eta_z_j_1_max__ = (N * save_scores);
        for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
            vars__.push_back(eta_z(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_random_sigma = in__.vector_lb_constrain(0, (2 * hier_coding));
        size_t eta_random_sigma_j_1_max__ = (2 * hier_coding);
        for (size_t j_1__ = 0; j_1__ < eta_random_sigma_j_1_max__; ++j_1__) {
            vars__.push_back(eta_random_sigma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_mean_s = in__.vector_constrain(((K - 1) * sum_coding));
        size_t eta_mean_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_mean_s_j_1_max__; ++j_1__) {
            vars__.push_back(eta_mean_s(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta_sd_s = in__.vector_lb_constrain(0, ((K - 1) * sum_coding));
        size_t eta_sd_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_sd_s_j_1_max__; ++j_1__) {
            vars__.push_back(eta_sd_s(j_1__));
        }
        double hm_tau = in__.scalar_constrain();
        vars__.push_back(hm_tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_param = in__.vector_constrain((3 * use_hmre));
        size_t hm_param_j_1_max__ = (3 * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            vars__.push_back(hm_param(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_item = in__.vector_constrain((J * use_hmre));
        size_t hm_item_j_1_max__ = (J * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            vars__.push_back(hm_item(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> hm_lambda = in__.vector_constrain(total);
        size_t hm_lambda_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            vars__.push_back(hm_lambda(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 297;
            validate_non_negative_index("random_sigma_all", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            Eigen::Matrix<double, Eigen::Dynamic, 1> random_sigma_all((total + (2 * hier_coding)));
            stan::math::initialize(random_sigma_all, DUMMY_VAR__);
            stan::math::fill(random_sigma_all, DUMMY_VAR__);
            stan::math::assign(random_sigma_all,append_row(random_sigma, eta_random_sigma));
            current_statement_begin__ = 298;
            validate_non_negative_index("random", "K", K);
            validate_non_negative_index("random", "(total + (2 * hier_coding))", (total + (2 * hier_coding)));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> random(K, (total + (2 * hier_coding)));
            stan::math::initialize(random, DUMMY_VAR__);
            stan::math::fill(random, DUMMY_VAR__);
            stan::math::assign(random,z_to_random(random_z, random_sigma_all, random_L, pstream__));
            current_statement_begin__ = 299;
            validate_non_negative_index("lambda_random", "K", K);
            validate_non_negative_index("lambda_random", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> lambda_random(K, J);
            stan::math::initialize(lambda_random, DUMMY_VAR__);
            stan::math::fill(lambda_random, DUMMY_VAR__);
            stan::math::assign(lambda_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 1, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 300;
            validate_non_negative_index("resid_random", "K", K);
            validate_non_negative_index("resid_random", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> resid_random(K, J);
            stan::math::initialize(resid_random, DUMMY_VAR__);
            stan::math::fill(resid_random, DUMMY_VAR__);
            stan::math::assign(resid_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 2, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 301;
            validate_non_negative_index("nu_random", "K", K);
            validate_non_negative_index("nu_random", "J", J);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> nu_random(K, J);
            stan::math::initialize(nu_random, DUMMY_VAR__);
            stan::math::fill(nu_random, DUMMY_VAR__);
            stan::math::assign(nu_random,stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(get_base1(lamResNu_indices, 3, "lamResNu_indices", 1)), stan::model::nil_index_list())), "random"));
            current_statement_begin__ = 302;
            validate_non_negative_index("eta_mean", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_mean(K);
            stan::math::initialize(eta_mean, DUMMY_VAR__);
            stan::math::fill(eta_mean, DUMMY_VAR__);
            stan::math::assign(eta_mean,(sum_coding ? stan::math::promote_scalar<local_scalar_t__>(eta_means_stz(eta_mean_s, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((total + 1)), stan::model::nil_index_list())), "random")) ));
            current_statement_begin__ = 303;
            validate_non_negative_index("eta_sd", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_sd(K);
            stan::math::initialize(eta_sd, DUMMY_VAR__);
            stan::math::fill(eta_sd, DUMMY_VAR__);
            stan::math::assign(eta_sd,(sum_coding ? stan::math::promote_scalar<local_scalar_t__>(eta_sds_pto(eta_sd_s, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(stan::math::exp(stan::model::rvalue(random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((total + 2)), stan::model::nil_index_list())), "random"))) ));
            current_statement_begin__ = 304;
            validate_non_negative_index("lambda_lowerbound", "J", J);
            Eigen::Matrix<double, 1, Eigen::Dynamic> lambda_lowerbound(J);
            stan::math::initialize(lambda_lowerbound, DUMMY_VAR__);
            stan::math::fill(lambda_lowerbound, DUMMY_VAR__);
            stan::math::assign(lambda_lowerbound,compute_lambda_lowerbounds(lambda_random, pstream__));
            current_statement_begin__ = 305;
            validate_non_negative_index("lambda", "J", J);
            Eigen::Matrix<double, 1, Eigen::Dynamic> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda, DUMMY_VAR__);
            stan::math::assign(lambda,add(stan::math::exp(lambda_log), lambda_lowerbound));
            current_statement_begin__ = 306;
            validate_non_negative_index("eta", "(N * save_scores)", (N * save_scores));
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta((N * save_scores));
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 307;
            validate_non_negative_index("multi_normal_mu", "(K * marginalize)", (K * marginalize));
            validate_non_negative_index("multi_normal_mu", "(J * marginalize)", (J * marginalize));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> multi_normal_mu((K * marginalize), (J * marginalize));
            stan::math::initialize(multi_normal_mu, DUMMY_VAR__);
            stan::math::fill(multi_normal_mu, DUMMY_VAR__);
            current_statement_begin__ = 308;
            validate_non_negative_index("multi_normal_sigma", "(J * marginalize)", (J * marginalize));
            validate_non_negative_index("multi_normal_sigma", "(J * marginalize)", (J * marginalize));
            validate_non_negative_index("multi_normal_sigma", "(K * marginalize)", (K * marginalize));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > multi_normal_sigma((K * marginalize), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((J * marginalize), (J * marginalize)));
            stan::math::initialize(multi_normal_sigma, DUMMY_VAR__);
            stan::math::fill(multi_normal_sigma, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 310;
            if (as_bool(save_scores)) {
                current_statement_begin__ = 311;
                stan::math::assign(eta, add(stan::model::rvalue(eta_mean, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_mean"), elt_multiply(eta_z, stan::model::rvalue(eta_sd, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "eta_sd"))));
            } else {
                current_statement_begin__ = 314;
                stan::math::assign(multi_normal_mu, marg_expect_uni(lambda, nu, lambda_random, nu_random, eta_mean, pstream__));
                current_statement_begin__ = 315;
                stan::math::assign(multi_normal_sigma, marg_cov_uni(lambda, resid_log, lambda_random, resid_random, eta_sd, pstream__));
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 297;
            check_greater_or_equal(function__, "random_sigma_all", random_sigma_all, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t random_sigma_all_j_1_max__ = (total + (2 * hier_coding));
                for (size_t j_1__ = 0; j_1__ < random_sigma_all_j_1_max__; ++j_1__) {
                    vars__.push_back(random_sigma_all(j_1__));
                }
                size_t random_j_2_max__ = (total + (2 * hier_coding));
                size_t random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                        vars__.push_back(random(j_1__, j_2__));
                    }
                }
                size_t lambda_random_j_2_max__ = J;
                size_t lambda_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                        vars__.push_back(lambda_random(j_1__, j_2__));
                    }
                }
                size_t resid_random_j_2_max__ = J;
                size_t resid_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                        vars__.push_back(resid_random(j_1__, j_2__));
                    }
                }
                size_t nu_random_j_2_max__ = J;
                size_t nu_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                        vars__.push_back(nu_random(j_1__, j_2__));
                    }
                }
                size_t eta_mean_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_mean(j_1__));
                }
                size_t eta_sd_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_sd(j_1__));
                }
                size_t lambda_lowerbound_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda_lowerbound(j_1__));
                }
                size_t lambda_j_1_max__ = J;
                for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda(j_1__));
                }
                size_t eta_j_1_max__ = (N * save_scores);
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    vars__.push_back(eta(j_1__));
                }
                size_t multi_normal_mu_j_2_max__ = (J * marginalize);
                size_t multi_normal_mu_j_1_max__ = (K * marginalize);
                for (size_t j_2__ = 0; j_2__ < multi_normal_mu_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < multi_normal_mu_j_1_max__; ++j_1__) {
                        vars__.push_back(multi_normal_mu(j_1__, j_2__));
                    }
                }
                size_t multi_normal_sigma_j_2_max__ = (J * marginalize);
                size_t multi_normal_sigma_j_1_max__ = (J * marginalize);
                size_t multi_normal_sigma_k_0_max__ = (K * marginalize);
                for (size_t j_2__ = 0; j_2__ < multi_normal_sigma_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < multi_normal_sigma_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < multi_normal_sigma_k_0_max__; ++k_0__) {
                            vars__.push_back(multi_normal_sigma[k_0__](j_1__, j_2__));
                        }
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 395;
            validate_non_negative_index("RE_cor", "total", total);
            validate_non_negative_index("RE_cor", "total", total);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> RE_cor(total, total);
            stan::math::initialize(RE_cor, DUMMY_VAR__);
            stan::math::fill(RE_cor, DUMMY_VAR__);
            stan::math::assign(RE_cor,stan::model::rvalue(L_to_cor(random_L, pstream__), stan::model::cons_list(stan::model::index_min_max(1, total), stan::model::cons_list(stan::model::index_min_max(1, total), stan::model::nil_index_list())), "L_to_cor(random_L, pstream__)"));
            // validate, write generated quantities
            current_statement_begin__ = 395;
            size_t RE_cor_j_2_max__ = total;
            size_t RE_cor_j_1_max__ = total;
            for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                    vars__.push_back(RE_cor(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_redifhm_all";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t lambda_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < lambda_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resid_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_z_j_2_max__ = (total + (2 * hier_coding));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_L_j_2_max__ = (total + (2 * hier_coding));
        size_t random_L_j_1_max__ = (total + (2 * hier_coding));
        for (size_t j_2__ = 0; j_2__ < random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_L" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_sigma_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_z_j_1_max__ = (N * save_scores);
        for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_random_sigma_j_1_max__ = (2 * hier_coding);
        for (size_t j_1__ = 0; j_1__ < eta_random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_mean_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_mean_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_mean_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_sd_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_sd_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_sd_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "hm_tau";
        param_names__.push_back(param_name_stream__.str());
        size_t hm_param_j_1_max__ = (3 * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_item_j_1_max__ = (J * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_item" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_lambda_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t random_sigma_all_j_1_max__ = (total + (2 * hier_coding));
            for (size_t j_1__ = 0; j_1__ < random_sigma_all_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_sigma_all" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t random_j_2_max__ = (total + (2 * hier_coding));
            size_t random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_random_j_2_max__ = J;
            size_t lambda_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t resid_random_j_2_max__ = J;
            size_t resid_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "resid_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t nu_random_j_2_max__ = J;
            size_t nu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "nu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_mean_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_mean" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_sd_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_lowerbound_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_lowerbound" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = (N * save_scores);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t multi_normal_mu_j_2_max__ = (J * marginalize);
            size_t multi_normal_mu_j_1_max__ = (K * marginalize);
            for (size_t j_2__ = 0; j_2__ < multi_normal_mu_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < multi_normal_mu_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "multi_normal_mu" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t multi_normal_sigma_j_2_max__ = (J * marginalize);
            size_t multi_normal_sigma_j_1_max__ = (J * marginalize);
            size_t multi_normal_sigma_k_0_max__ = (K * marginalize);
            for (size_t j_2__ = 0; j_2__ < multi_normal_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < multi_normal_sigma_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < multi_normal_sigma_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "multi_normal_sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t RE_cor_j_2_max__ = total;
        size_t RE_cor_j_1_max__ = total;
        for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "RE_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t lambda_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < lambda_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resid_log_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < resid_log_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resid_log" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_z_j_2_max__ = (total + (2 * hier_coding));
        size_t random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t random_L_j_1_max__ = (((total + (2 * hier_coding)) * ((total + (2 * hier_coding)) - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < random_L_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_L" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t random_sigma_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_z_j_1_max__ = (N * save_scores);
        for (size_t j_1__ = 0; j_1__ < eta_z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_random_sigma_j_1_max__ = (2 * hier_coding);
        for (size_t j_1__ = 0; j_1__ < eta_random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_mean_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_mean_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_mean_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_sd_s_j_1_max__ = ((K - 1) * sum_coding);
        for (size_t j_1__ = 0; j_1__ < eta_sd_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_sd_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "hm_tau";
        param_names__.push_back(param_name_stream__.str());
        size_t hm_param_j_1_max__ = (3 * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_param_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_param" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_item_j_1_max__ = (J * use_hmre);
        for (size_t j_1__ = 0; j_1__ < hm_item_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_item" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hm_lambda_j_1_max__ = total;
        for (size_t j_1__ = 0; j_1__ < hm_lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hm_lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t random_sigma_all_j_1_max__ = (total + (2 * hier_coding));
            for (size_t j_1__ = 0; j_1__ < random_sigma_all_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "random_sigma_all" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t random_j_2_max__ = (total + (2 * hier_coding));
            size_t random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t lambda_random_j_2_max__ = J;
            size_t lambda_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < lambda_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "lambda_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t resid_random_j_2_max__ = J;
            size_t resid_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < resid_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < resid_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "resid_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t nu_random_j_2_max__ = J;
            size_t nu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < nu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < nu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "nu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_mean_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_mean_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_mean" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_sd_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < eta_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_lowerbound_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_lowerbound_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_lowerbound" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_j_1_max__ = J;
            for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_j_1_max__ = (N * save_scores);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t multi_normal_mu_j_2_max__ = (J * marginalize);
            size_t multi_normal_mu_j_1_max__ = (K * marginalize);
            for (size_t j_2__ = 0; j_2__ < multi_normal_mu_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < multi_normal_mu_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "multi_normal_mu" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t multi_normal_sigma_j_2_max__ = (J * marginalize);
            size_t multi_normal_sigma_j_1_max__ = (J * marginalize);
            size_t multi_normal_sigma_k_0_max__ = (K * marginalize);
            for (size_t j_2__ = 0; j_2__ < multi_normal_sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < multi_normal_sigma_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < multi_normal_sigma_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "multi_normal_sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t RE_cor_j_2_max__ = total;
        size_t RE_cor_j_1_max__ = total;
        for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "RE_cor" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_redifhm_all_namespace::model_redifhm_all stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
