% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_ale}
\alias{plot_ale}
\title{Plot Accumulated Local Effects (ALE)}
\usage{
plot_ale(
  analysis_object,
  feature,
  group = NULL,
  grid.size = 20,
  use_test = FALSE,
  plot = TRUE
)
}
\arguments{
\item{analysis_object}{A fitted \code{wrap_object} with model results or
previously computed ALE values.}

\item{feature}{Character. Name of the continuous feature for which ALE
should be computed.}

\item{group}{Optional character. A grouping variable to compute grouped ALE
curves.}

\item{grid.size}{Integer. Number of intervals to partition the feature domain
(default = 20).}

\item{use_test}{Logical. If TRUE, ALE is computed using the test set
(default = FALSE).}

\item{plot}{Logical. If TRUE, displays the ALE plot and returns \code{wrap_object};
if FALSE, returns the ggplot object without modifying the object.}
}
\value{
If \code{plot = TRUE}, returns the updated \code{wrap_object} and prints the ALE plot.
If \code{plot = FALSE}, returns a ggplot object containing the ALE visualization.
}
\description{
The \strong{plot_ale()} function computes and visualizes
\strong{Accumulated Local Effects (ALE)} for a selected feature, following the
approach described in \emph{Interpretable Machine Learning} by Christoph Molnar.
ALE plots quantify how changes in a feature locally influence model
predictions, offering a robust alternative to Partial Dependence Plots (PDP)
by avoiding extrapolation and handling correlated predictors more reliably.
}
\examples{
# After fitting a model with fine_tuning(wrap_object):
# plot_ale(wrap_object, feature = "age")
}
\references{
Molnar, C. (2022). \emph{Interpretable Machine Learning}.\cr
\url{https://christophm.github.io/interpretable-ml-book/}
}
\seealso{
\code{\link{sensitivity_analysis}}
}
