% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_best_hyperparameters}
\alias{table_best_hyperparameters}
\title{Best Hyperparameters Configuration}
\usage{
table_best_hyperparameters(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}

\item{show_table}{Boolean. Whether to print the table.}
}
\value{
Tibble with best hyperparameter configuration.
}
\description{
The \strong{table_best_hyperparameters()} function extracts and presents the
optimal hyperparameter configuration identified during the model fine-tuning
process. This function validates that the model has been properly trained
and that hyperparameter tuning has been performed, combining both constant
and optimized hyperparameters to generate a comprehensive table with the
configuration that maximizes performance according to the specified primary
metric. The function includes optional interactive visualization
capabilities through the show_table parameter.
}
\examples{
# Note: For obtaining hyoperparameters table the user needs to
# complete till fine_tuning( ) function.

set.seed(123) # For reproducibility
wrap_object <- preprocessing(df = sim_data[1:300 ,],
                             formula = psych_well ~ depression + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest",
                           hyperparameters = list(mtry = 2, trees = 3))
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")

# And then, you can obtain the best hyperparameters table.

table_best_hyp <- table_best_hyperparameters(wrap_object)
}
