% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_integrated_gradients_results}
\alias{table_integrated_gradients_results}
\title{Integrated Gradients Summarized Results Table}
\usage{
table_integrated_gradients_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "Integrated Gradients")'.}

\item{show_table}{Boolean. Whether to print the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with
Integrated Gradient summarized results.
}
\description{
The \strong{table_integrated_gradients_results()} function implements a
summarized metrics scheme for Integrated Gradients values. This methodology,
specifically designed for neural networks, calculates feature importance
through gradient integration along paths from baseline to input. Three
different metrics are computed:
\itemize{
\item \strong{Mean Absolute Value}
\item \strong{Standard Deviation of Mean Absolute Value}
\item \strong{Directional Sensitivity Value} (Cov(Feature values, IG values) / Var(Feature values))
}
}
\examples{
# Note: For obtaining the table with Integrated Gradients method results
# the user needs to complete till sensitivity_analysis() function of the
# MLwrap pipeline using the Integrated Gradient method.
# See the full pipeline example under sensitivity_analysis
# (Requires sensitivity_analysis(methods = "Integrated Gradients"))
# Final call signature:
# table_integrated_gradients_results(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
