% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_bigten_d.R
\name{scale_fill_bigten_d}
\alias{scale_fill_bigten_d}
\title{Plotting with Big Ten palettes for fill ggplot2}
\usage{
scale_fill_bigten_d(palette = "primary", direction = 1, ...)
}
\arguments{
\item{palette}{Type of palette: "primary" or "secondary"}

\item{direction}{Sets order of colors. Default direction is 1. If direction is -1,
palette color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A ggproto object defining a discrete fill scale for use with ggplot2.
}
\description{
Plotting with Big Ten palettes for fill ggplot2
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, fill = factor(cyl))) +
  geom_point(shape = 21) +
  scale_fill_bigten_d(palette = "primary")
}
