% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMWRwqx.R
\name{readMWRwqx}
\alias{readMWRwqx}
\title{Read water quality exchange (wqx) metadata input from an external file}
\usage{
readMWRwqx(wqxpth, runchk = TRUE, warn = TRUE)
}
\arguments{
\item{wqxpth}{character string of path to the wqx metadata file}

\item{runchk}{logical to run data checks with \code{\link{checkMWRwqx}}}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
A formatted data frame that can be used for downstream analysis
}
\description{
Read water quality exchange (wqx) metadata input from an external file
}
\details{
Date are imported with \code{\link[readxl]{read_excel}}, checked with \code{\link{checkMWRwqx}}.
}
\examples{
wqxpth <- system.file('extdata/ExampleWQX.xlsx', package = 'MassWateR')

wqxdat <- readMWRwqx(wqxpth)
head(wqxdat)
}
