% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRsummary.R
\name{utilMWRsummary}
\alias{utilMWRsummary}
\title{Summarize a results data frame by a grouping variable}
\usage{
utilMWRsummary(dat, accdat, param, sumfun = "auto", confint)
}
\arguments{
\item{dat}{input data frame}

\item{accdat}{\code{data.frame} for data quality objectives file for accuracy as returned by \code{\link{readMWRacc}}}

\item{param}{character string for the parameter to evaluate as provided in the \code{"Parameter"} column of \code{"accdat"}}

\item{sumfun}{character indicating one of \code{"auto"} (default), \code{"mean"}, \code{"geomean"}, \code{"median"}, \code{"min"}, or \code{"max"}, see details}

\item{confint}{logical if user expects a confidence interval to be returned with the summary}
}
\value{
A summarized data frame, a warning will be returned if the confidence interval cannot be estimated and \code{confint = TRUE}
}
\description{
Summarize a results data frame by a grouping variable
}
\details{
This function summarizes a results data frame by an existing grouping variable using the function supplied to \code{sumfun}. The mean or geometric mean is used for \code{sumfun = "auto"} based on information in the data quality objective file for accuracy, i.e., parameters with "log" in any of the columns are summarized with the geometric mean, otherwise arithmetic. Using \code{"mean"} or \code{"geomean"} for \code{sumfun} will apply the appropriate function regardless of information in the data quality objective file for accuracy.
}
\examples{
library(dplyr)

# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# fill BDL, AQL
resdat <- utilMWRlimits(resdat = resdat, accdat = accdat, param = "DO")

dat <- resdat \%>\% 
  group_by(`Monitoring Location ID`)
 
# summarize sites by mean 
utilMWRsummary(dat, accdat, param = 'DO', sumfun = 'auto', confint = TRUE)

# summarize sites by minimum
utilMWRsummary(dat, accdat, param = 'DO', sumfun = 'min', confint = FALSE)
}
