% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cv.R
\name{calculate_cv}
\alias{calculate_cv}
\title{Add mean, SD and CV}
\usage{
calculate_cv(
  metalyzer_se,
  groups = NULL,
  cv_thresholds = c(0.1, 0.2, 0.3),
  na.rm = TRUE
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{groups}{A vector of column names of aggregated_data to calculate mean,
SD and CV group wise. If the column does not exists in aggregated_data it is
automatically added from meta data. The default value is set to NULL, which
uses the existing grouping of aggregated_data.}

\item{cv_thresholds}{A numeric vector of upper thresholds (CV <= t) between 0
and 1 for CV categorization.}

\item{na.rm}{a logical evaluating to TRUE or FALSE indicating whether NA
values should be stripped before the computation proceeds.}
}
\value{
An updated aggregated_data tibble data frame
}
\description{
This function calculates the mean, standard deviation (SD)
and the coefficient of variation (CV) for each group and adds them to
aggregated_data.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_extraction_data())
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Extraction_Method = "Sample Description"
)
metalyzer_se <- filterMetaData(
  metalyzer_se,
  Tissue == "Drosophila"
)
metalyzer_se <- calculate_cv(
  metalyzer_se,
  groups = c("Tissue", "Extraction_Method", "Metabolite"),
  cv_thresholds = c(0.1, 0.2, 0.3),
  na.rm = TRUE
)
}
