% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_log2FC.R
\name{plot_log2FC}
\alias{plot_log2FC}
\title{Plot log2 fold change}
\usage{
plot_log2FC(
  metalyzer_se,
  signif_colors = c(`#5F5F5F` = 1, `#FEBF6E` = 0.1, `#EE5C42` = 0.05, `#8B1A1A` = 0.01),
  hide_labels_for = c(),
  class_colors = "MetAlyzer",
  polarity_file = "MxPQuant500",
  vulcano = FALSE
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{signif_colors}{signif_colors}

\item{hide_labels_for}{vector of Metabolites or Classes for which no labels
are printed}

\item{class_colors}{class_colors}

\item{polarity_file}{polarity_file}

\item{vulcano}{boolean value to plot a vulcano plot}
}
\value{
ggplot object
}
\description{
This method plots the log2 fold change for each metabolite.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)
metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)

# p_vulcano <- plot_log2FC(metalyzer_se, vulcano=TRUE)
# p_fc <- plot_log2FC(metalyzer_se, vulcano=FALSE)
}
