% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{graph_starting_values}
\alias{graph_starting_values}
\title{Starting values for random field models on metric graphs}
\usage{
graph_starting_values(
  graph,
  model = c("alpha1", "alpha2", "isoExp", "GL1", "GL2"),
  data = TRUE,
  data_name = NULL,
  range_par = FALSE,
  nu = FALSE,
  manual_data = NULL,
  like_format = FALSE,
  log_scale = FALSE,
  model_options = list(),
  rec_tau = TRUE,
  factor_start_range = 0.3,
  type_start_range_bbox = "diag"
)
}
\arguments{
\item{graph}{A \code{metric_graph} object.}

\item{model}{Type of model, "alpha1", "alpha2", "isoExp", "GL1", and "GL2"
are supported.}

\item{data}{Should the data be used to obtain improved starting values?}

\item{data_name}{The name of the response variable in \code{graph$data}.}

\item{range_par}{Should an initial value for range parameter be returned
instead of for kappa?}

\item{nu}{Should an initial value for nu be returned?}

\item{manual_data}{A vector (or matrix) of response variables.}

\item{like_format}{Should the starting values be returned with sigma.e as the
last element? This is the format for the likelihood constructor from the
'rSPDE' package.}

\item{log_scale}{Should the initial values be returned in log scale?}

\item{model_options}{List object containing the model options.}

\item{rec_tau}{Should a starting value for the reciprocal of tau be given?}

\item{factor_start_range}{Factor to multiply the max/min/diagonal dimension of the bounding box to obtain a starting value for range. Default is 0.5.}

\item{type_start_range_bbox}{Which dimension from the bounding box should be used? The options are 'diag', the default, 'max' and 'min'.}
}
\value{
A vector, \code{c(start_sigma_e, start_sigma, start_kappa)}
}
\description{
Computes appropriate starting values for optimization of Gaussian random
field models on metric graphs.
}
