% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineage_tracing.R
\name{choose_features_clustering}
\alias{choose_features_clustering}
\title{choose_features_clustering}
\usage{
choose_features_clustering(
  heteroplasmy_matrix,
  allele_matrix,
  cluster,
  top_pos,
  deepSplit_param,
  minClusterSize_param,
  min_value_vector,
  threshold = 0.2,
  index,
  max_frac = 0.7
)
}
\arguments{
\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}

\item{allele_matrix}{Fourth element returned by \emph{get_heteroplasmy}.}

\item{cluster}{Vector specifying a partition of the samples.}

\item{top_pos}{Numeric value. Number of bases sorted with decreasing values
of distance variance (see section \emph{Details} below) among samples. If
\emph{relevant_bases}=NULL, then the bases for performing hierarchical clustering
are the ones whose relative variance (variance of the base divided sum of
variance among \emph{top_pos} bases) is above \emph{min_value}.}

\item{deepSplit_param}{Integer value between 0 and 4 for the \emph{deepSplit}
parameter of the function \emph{cutreeHybrid}. See section \emph{Details}
below.}

\item{minClusterSize_param}{Integer value specifying the \emph{minClusterSize}
parameter of the function \emph{cutreeHybrid}. See section \emph{Details}
below.}

\item{min_value_vector}{Numeric vector. For each value in the vector, the function
\emph{clustering_angular_distance} is run with parameter \emph{min_value} equal to
one element of the vector \emph{min_value_vector}.}

\item{threshold}{Numeric value. If a base has heteroplasmy greater or equal
to \emph{threshold} in more than \emph{max_frac} of cells, then the base is
not considered for down stream analysis.}

\item{index}{Fifth element returned by \emph{get_heteroplasmy}.}

\item{max_frac}{Numeric value.If a base has heteroplasmy greater or equal to
\emph{threshold} in more than \emph{max_frac} of cells, then the base is not
considered for down stream analysis.}
}
\value{
Clustree plot returned by function \emph{clustree} from package \emph{clustree}.
}
\description{
choose_features_clustering
}
\seealso{
\url{https://cran.r-project.org/package=clustree}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
