% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeResults.R
\name{MergeResults}
\alias{MergeResults}
\title{Merge Lists Returned From Separate Simulations With MonteCarlo().}
\usage{
MergeResults(identifier, path)
}
\arguments{
\item{identifier}{String that is common to the names of the files that are supposed to be merged.}

\item{path}{String specifying the path to directory that contains the files.}
}
\description{
\code{MergeResults} is a utility function that allows to merge the output from separate simulations
using the same function and parameter grid.
}
\details{
To merge two or more files with simulation results they have to be saved using \code{save}.
The identifier string has to be part of the name of all targeted files, but not part of the names of any 
other files in the directory.
}
\examples{
\donttest{out<-MergeResults(identifier="MonteCarloResults", path="C:/Users/")
summary(out)}
}
