% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inscribeEllipse.r
\name{inscribeEllipseRot}
\alias{inscribeEllipseRot}
\title{Inscribe the maximum ellipse into any arbitrary 2D polygon including rotations}
\usage{
inscribeEllipseRot(poly, step = 0.3, iters = 999, rotsteps = 45)
}
\arguments{
\item{poly}{k x 2 matrix containing ordered coordinates forming the polygon}

\item{step}{stepsize}

\item{iters}{integer: number of iterations to run}

\item{rotsteps}{integer: number rotational steps}
}
\value{
\item{center}{ center of ellipse}
\item{radius.x}{ x-dim of ellipse}
\item{radius.y}{ y-dim of ellipse}
\item{maxarea}{area of ellipse}
\item{theta}{angle of optimal rotation}
\item{polyRot}{k x 2 matrix of cooridnates rotated around barycenter to maximize ellipse area}
}
\description{
Inscribe the maximum ellipse into any arbitrary 2D polygon including rotations
}
\examples{
require(shapes)
require(DescTools)
poly <- gorf.dat[c(1,6:8,2:5),,1]
\dontrun{
myellipse <- inscribeEllipseRot(poly,iters = 999,rotsteps=10)
plot(poly,asp=1)
lines(rbind(poly,poly[1,]))
DrawEllipse(x=myellipse$center[1],y=myellipse$center[2],radius.x=myellipse$radius.x,
            radius.y = myellipse$radius.y,col="red")
} 
}
