% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warpmovie.matrix.r, R/warpmovie.r
\name{warpmovie3d}
\alias{warpmovie3d}
\alias{warpmovie3d.matrix}
\alias{warpmovie2d}
\alias{warpmovie3d.mesh3d}
\title{Creates a sequence of images showing predefined steps of warping two meshes or landmark configurations (2D and 3D) into each other}
\usage{
warpmovie3d(
  x,
  y,
  n,
  col = "green",
  palindrome = FALSE,
  folder = NULL,
  movie = "warpmovie",
  ...
)

\method{warpmovie3d}{matrix}(
  x,
  y,
  n,
  col = "green",
  palindrome = FALSE,
  folder = NULL,
  movie = "warpmovie",
  add = FALSE,
  close = TRUE,
  countbegin = 0,
  ask = TRUE,
  radius = NULL,
  links = NULL,
  lwd = 1,
  ...
)

warpmovie2d(
  x,
  y,
  n,
  col = "green",
  palindrome = FALSE,
  folder = NULL,
  movie = "warpmovie",
  links = NULL,
  lwd = 1,
  imagedim = "800x800",
  par = list(xaxt = "n", yaxt = "n", bty = "n"),
  ...
)

\method{warpmovie3d}{mesh3d}(
  x,
  y,
  n,
  col = NULL,
  palindrome = FALSE,
  folder = NULL,
  movie = "warpmovie",
  add = FALSE,
  close = TRUE,
  countbegin = 0,
  ask = TRUE,
  radius = NULL,
  xland = NULL,
  yland = NULL,
  lmcol = "black",
  ...
)
}
\arguments{
\item{x}{mesh to start with (object of class mesh3d)}

\item{y}{resulting mesh (object of class mesh3d), having the same amount of
vertices and faces than the starting mesh}

\item{n}{integer: amount of intermediate steps.}

\item{col}{color of the mesh}

\item{palindrome}{logical: if TRUE, the procedure will go forth and back.}

\item{folder}{character: output folder for created images (optional)}

\item{movie}{character: name of the output files}

\item{\dots}{additional arguments passed to \code{\link[rgl]{shade3d}} (3D) or
\code{\link{points}} (2D).}

\item{add}{logical: if TRUE, the movie will be added to the focussed
rgl-windows.}

\item{close}{logical: if TRUE, the rgl window will be closed when finished.
width and 200 the height of the image.}

\item{countbegin}{integer: number to start image sequence.}

\item{ask}{logical: if TRUE, the viewpoint can be selected manually.}

\item{radius}{numeric: define size of spheres (overides atuomatic size
estimation).}

\item{links}{vector or list of vectors containing wireframe information to
connect landmarks (optional).}

\item{lwd}{numeric: controls width of lines defined by "links".}

\item{imagedim}{character of pattern "100x200" where 100 determines the
width and 200 the height of the image.}

\item{par}{list of graphial parameters: details can be found here:
\code{\link{par}}.}

\item{xland}{optional argument: add landmarks on mesh x}

\item{yland}{optional argument: add landmarks on mesh y}

\item{lmcol}{optional argument: color of landmarks xland and yland}
}
\description{
Creates a sequence of images showing predefined steps of warping two meshes
or landmark configurations (2D and 3D) into each other
}
\details{
given two landmark configurations or two meshes with the same amount of
vertices and faces (e.g a mesh and its warped counterpart), the starting
configuration/mesh will be subsequently transformed into the final
configuration/mesh by splitting the differences into a predefined set of
steps.

A series of png files will be saved to disk. These can be joined to animated
gifs by external programs such as imagemagick or used to create animations
in PDFs in a latex environment (e.g. latex package: aninmate).
}
\examples{


###3D example
 data(nose)##load data
if (interactive()){
##warp a mesh onto another landmark configuration:
longnose.mesh <- tps3d(shortnose.mesh,shortnose.lm,longnose.lm,threads=1)

warpmovie3d(shortnose.mesh,longnose.mesh,n=15)## create 15 images.

### ad some landmarks
warpmovie3d(shortnose.mesh,longnose.mesh,n=15,xland=shortnose.lm,
            yland=longnose.lm)## create 15 images.


### restrict to landmarks
warpmovie3d(shortnose.lm,longnose.lm,n=15,movie="matrixmovie")## create 15 images.

### the images are now stored in your current working directory and can
### be concatenated to a gif using an external program such as
### imagemagick.
}
### 2D example
if (require(shapes)) {
bb <- procSym(gorf.dat)
### morph superimposed first specimen onto sample mean
warpmovie2d(bb$rotated[,,1],bb$mshape,n=20,links=c(1,5,4:2,8:6,1),imagedim="600x400")
## remove files
unlink("warpmovie00*")
}
}
\seealso{
\code{\link{ply2mesh},\link{file2mesh},\link{mesh2ply},\link{tps3d}}
}
\author{
Stefan Schlager
}
