% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_sib_model.R
\name{stochastic_sib_model}
\alias{stochastic_sib_model}
\title{Stochastic SIB model for infected cases simulation}
\usage{
stochastic_sib_model(
  mu,
  beta,
  rho,
  sigma,
  gamma,
  alpha,
  mu_B,
  m = 0.3,
  theta,
  nnodes,
  POP_node,
  fluxes,
  time_sim,
  y0
)
}
\arguments{
\item{mu}{population natality and mortality rate (day^-1)}

\item{beta}{contact rate}

\item{rho}{immunity loss rate (day^-1)}

\item{sigma}{symptomatic ratio, i.e., fraction of infected people that develop symptoms and are infective. 
(The remaining fraction enters directly the recovered compartment.)}

\item{gamma}{rate at which people recover from cholera (day^-1)}

\item{alpha}{cholera induced mortality rate (day^-1)}

\item{mu_B}{death rate of V.cholerae in the aquatic environment (day^-1)}

\item{m}{parameter for infection force, default value is 0.3}

\item{theta}{contamination rate}

\item{nnodes}{number of nodes/cities}

\item{POP_node}{vector, length represents number of cities/nodes; vector represents
population at each node}

\item{fluxes}{matrix, number of nodes x number of nodes 
where each row contains the probabilities a person travels from the given city (by Row Index) to another city (by Column Index).}

\item{time_sim}{time steps for simulation, e.g., seq(0, 100, 0.1)}

\item{y0}{initial condition for stochastic_sib_model, output of 'initial_condition_sib_model'}
}
\value{
a matrix, nnodes x number of time steps, representing number of new cases at each node, each time step
}
\description{
\code{stochastic_sib_model} Stochastic SIB model for infected cases simulation
}
\examples{
set.seed(2020)
popu <- rep(20000, 10)
sigma <- 0.05
mu_B <- 0.2
theta_max <- 16
theta <- runif(10, 0.1, 0.9) * theta_max
y0 <- initial_condition_sib_model(popu, sigma, mu_B, theta, c(3))
time_sim <- seq(0, 1, by=0.1)
mu <- 4e-05
beta_max <- 1 
rho <- 0
beta <- runif(10, 0.1, 0.9) * beta_max
gamma <- 0.2
alpha <- 0
humanmob.mass <- matrix(runif(100, 0.1, 0.9), 10, 10)
diag(humanmob.mass) <- 0
for (j in 1:10) {
  humanmob.mass[j, ] <- humanmob.mass[j, ]/sum(humanmob.mass[j, ])
}
simu.list = stochastic_sib_model(mu = mu, beta = beta, rho = rho, sigma = sigma, gamma = gamma,
                   alpha = alpha, mu_B = mu_B, theta = theta, nnodes = 10, POP_node = popu,
                   fluxes = humanmob.mass, time_sim = time_sim, y0 = y0)
}
\references{
Li, J., Manitz, J., Bertuzzo, E. and Kolaczyk, E.D. (2020). Sensor-based localization of epidemic sources on human mobility networks. arXiv preprint Available online: \url{https://arxiv.org/abs/2011.00138}.
}
\author{
Jun Li
}
